/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import org.broadinstitute.sting.gatk.walkers.phasing.AllelePair;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

class SNPallelePair
extends AllelePair {
    public SNPallelePair(Genotype gt) {
        super(gt);
        if (this.getTopAllele().getBases().length != 1) {
            throw new ReviewedStingException("LOGICAL ERROR: SNPallelePair may not contain non-SNP site!");
        }
        if (this.getBottomAllele().getBases().length != 1) {
            throw new ReviewedStingException("LOGICAL ERROR: SNPallelePair may not contain non-SNP site!");
        }
    }

    public byte getTopBase() {
        byte[] topBases = this.getTopAllele().getBases();
        return SNPallelePair.getSingleBase(topBases);
    }

    public byte getBottomBase() {
        byte[] bottomBases = this.getBottomAllele().getBases();
        return SNPallelePair.getSingleBase(bottomBases);
    }

    public boolean matchesTopBase(byte base) {
        return BaseUtils.basesAreEqual(base, this.getTopBase());
    }

    public byte getOtherBase(byte base) {
        byte topBase = this.getTopBase();
        byte botBase = this.getBottomBase();
        if (BaseUtils.basesAreEqual(base, topBase)) {
            return botBase;
        }
        if (BaseUtils.basesAreEqual(base, botBase)) {
            return topBase;
        }
        throw new ReviewedStingException("LOGICAL ERROR: base MUST match either TOP or BOTTOM!");
    }

    public static byte getSingleBase(byte[] bases) {
        return bases[0];
    }

    public static byte getSingleBase(Allele all) {
        return SNPallelePair.getSingleBase(all.getBases());
    }
}

