/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(description="Evaluation summary for multi-allelic variants")
public class MultiallelicSummary
extends VariantEvaluator {
    protected static final Logger logger = Logger.getLogger(MultiallelicSummary.class);
    @DataPoint(description="Number of processed loci")
    public long nProcessedLoci = 0L;
    @DataPoint(description="Number of SNPs")
    public int nSNPs = 0;
    @DataPoint(description="Number of multi-allelic SNPs")
    public int nMultiSNPs = 0;
    @DataPoint(description="% processed sites that are multi-allelic SNPs", format="%.5f")
    public double processedMultiSnpRatio = 0.0;
    @DataPoint(description="% SNP sites that are multi-allelic", format="%.3f")
    public double variantMultiSnpRatio = 0.0;
    @DataPoint(description="Number of Indels")
    public int nIndels = 0;
    @DataPoint(description="Number of multi-allelic Indels")
    public int nMultiIndels = 0;
    @DataPoint(description="% processed sites that are multi-allelic Indels", format="%.5f")
    public double processedMultiIndelRatio = 0.0;
    @DataPoint(description="% Indel sites that are multi-allelic", format="%.3f")
    public double variantMultiIndelRatio = 0.0;
    @DataPoint(description="Number of Transitions")
    public int nTi = 0;
    @DataPoint(description="Number of Transversions")
    public int nTv = 0;
    @DataPoint(description="Overall TiTv ratio", format="%.2f")
    public double TiTvRatio = 0.0;
    @DataPoint(description="Multi-allelic SNPs partially known")
    public int knownSNPsPartial = 0;
    @DataPoint(description="Multi-allelic SNPs completely known")
    public int knownSNPsComplete = 0;
    @DataPoint(description="Multi-allelic SNP Novelty Rate")
    public String SNPNoveltyRate = "NA";
    public int knownIndelsPartial = 0;
    public int knownIndelsComplete = 0;
    public String indelNoveltyRate = "NA";
    @DataPoint(description="Histogram of allele frequencies for most common SNP alternate allele")
    AFHistogram AFhistogramMaxSnp = new AFHistogram();
    @DataPoint(description="Histogram of allele frequencies for less common SNP alternate alleles")
    AFHistogram AFhistogramMinSnp = new AFHistogram();
    @DataPoint(description="Histogram of allele frequencies for most common Indel alternate allele")
    AFHistogram AFhistogramMaxIndel = new AFHistogram();
    @DataPoint(description="Histogram of allele frequencies for less common Indel alternate alleles")
    AFHistogram AFhistogramMinIndel = new AFHistogram();

    @Override
    public void initialize(VariantEvalWalker walker) {
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update0(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        this.nProcessedLoci += context.getSkippedBases() + (long)(ref == null ? 0 : 1);
    }

    @Override
    public String update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (eval == null || eval.isMonomorphicInSamples()) {
            return null;
        }
        switch (eval.getType()) {
            case SNP: {
                ++this.nSNPs;
                if (eval.isBiallelic()) break;
                ++this.nMultiSNPs;
                this.calculatePairwiseTiTv(eval);
                this.calculateSNPPairwiseNovelty(eval, comp);
                this.updateAFhistogram(eval, this.AFhistogramMaxSnp, this.AFhistogramMinSnp);
                break;
            }
            case INDEL: {
                ++this.nIndels;
                if (eval.isBiallelic()) break;
                ++this.nMultiIndels;
                this.calculateIndelPairwiseNovelty(eval, comp);
                this.updateAFhistogram(eval, this.AFhistogramMaxIndel, this.AFhistogramMinIndel);
                break;
            }
            default: {
                throw new UserException.BadInput("Unexpected variant context type: " + eval);
            }
        }
        return null;
    }

    private void calculatePairwiseTiTv(VariantContext vc) {
        for (Allele alt : vc.getAlternateAlleles()) {
            if (VariantContextUtils.isTransition(vc.getReference(), alt)) {
                ++this.nTi;
                continue;
            }
            ++this.nTv;
        }
    }

    private void calculateSNPPairwiseNovelty(VariantContext eval, VariantContext comp) {
        if (comp == null) {
            return;
        }
        int knownAlleles = 0;
        for (Allele alt : eval.getAlternateAlleles()) {
            if (!comp.getAlternateAlleles().contains(alt)) continue;
            ++knownAlleles;
        }
        if (knownAlleles == eval.getAlternateAlleles().size()) {
            ++this.knownSNPsComplete;
        } else if (knownAlleles > 0) {
            ++this.knownSNPsPartial;
        }
    }

    private void calculateIndelPairwiseNovelty(VariantContext eval, VariantContext comp) {
    }

    private void updateAFhistogram(VariantContext vc, AFHistogram max, AFHistogram min) {
        Object obj = vc.getAttribute("AF", null);
        if (obj == null || !(obj instanceof List)) {
            return;
        }
        List list = (List)obj;
        ArrayList<Double> AFs = new ArrayList<Double>(list.size());
        for (String str : list) {
            AFs.add(Double.valueOf(str));
        }
        Collections.sort(AFs);
        max.update((Double)AFs.get(AFs.size() - 1));
        for (int i = 0; i < AFs.size() - 1; ++i) {
            min.update((Double)AFs.get(i));
        }
    }

    private final String noveltyRate(int all, int known) {
        int novel = all - known;
        double rate = (double)novel / (1.0 * (double)all);
        return all == 0 ? "NA" : String.format("%.2f", rate);
    }

    @Override
    public void finalizeEvaluation() {
        this.processedMultiSnpRatio = (double)this.nMultiSNPs / (double)this.nProcessedLoci;
        this.variantMultiSnpRatio = (double)this.nMultiSNPs / (double)this.nSNPs;
        this.processedMultiIndelRatio = (double)this.nMultiIndels / (double)this.nProcessedLoci;
        this.variantMultiIndelRatio = (double)this.nMultiIndels / (double)this.nIndels;
        this.TiTvRatio = (double)this.nTi / (double)this.nTv;
        this.SNPNoveltyRate = this.noveltyRate(this.nMultiSNPs, this.knownSNPsPartial + this.knownSNPsComplete);
        this.indelNoveltyRate = this.noveltyRate(this.nMultiSNPs, this.knownIndelsPartial + this.knownIndelsComplete);
    }

    static class AFHistogram
    implements TableType {
        private Object[] rowKeys;
        private Object[] colKeys = new Object[]{"count"};
        private int[] AFhistogram;
        private static final double AFincrement = 0.01;
        private static final int numBins = 100;

        public AFHistogram() {
            this.rowKeys = AFHistogram.initRowKeys();
            this.AFhistogram = new int[this.rowKeys.length];
        }

        @Override
        public Object[] getColumnKeys() {
            return this.colKeys;
        }

        @Override
        public Object[] getRowKeys() {
            return this.rowKeys;
        }

        @Override
        public Object getCell(int row, int col) {
            return this.AFhistogram[row];
        }

        private static Object[] initRowKeys() {
            ArrayList<String> keyList = new ArrayList<String>(101);
            for (double a = 0.0; a <= 1.01; a += 0.01) {
                keyList.add(String.format("%.2f", a));
            }
            return keyList.toArray();
        }

        @Override
        public String getName() {
            return "AFHistTable";
        }

        public void update(double AF) {
            int bin;
            int n = bin = (int)(100.0 * MathUtils.round(AF, 2));
            this.AFhistogram[n] = this.AFhistogram[n] + 1;
        }
    }

    public static enum Type {
        SNP,
        INDEL;

    }
}

