/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.variantutils.ValidateVariants;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VariantsToPed
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(shortName="m", fullName="metaData", required=true, doc="Sample metadata file. You may specify a .fam file (in which case it will be copied to the file you provide as fam output)")
    File metaDataFile;
    @Output(shortName="bed", fullName="bed", required=true, doc="output ped file")
    PrintStream outBed;
    @Output(shortName="bim", fullName="bim", required=true, doc="output map file")
    PrintStream outBim;
    @Output(shortName="fam", fullName="fam", required=true, doc="output fam file")
    PrintStream outFam;
    @Argument(shortName="mgq", fullName="minGenotypeQuality", required=true, doc="If genotype quality is lower than this value, output NO_CALL")
    int minGenotypeQuality = 0;
    private ValidateVariants vv = new ValidateVariants();
    private static double APPROX_CM_PER_BP = 1.3333333333333333;
    private static final byte HOM_REF = 0;
    private static final byte HOM_VAR = 3;
    private static final byte HET = 2;
    private static final byte NO_CALL = 1;

    @Override
    public void initialize() {
        this.vv.variantCollection = this.variantCollection;
        this.vv.dbsnp = this.dbsnp;
        this.vv.DO_NOT_VALIDATE_FILTERED = true;
        this.vv.type = ValidateVariants.ValidationType.REF;
        try {
            this.outBed.write(new byte[]{108, 27, 1});
        }
        catch (IOException e) {
            throw new ReviewedStingException("error writing to output file.");
        }
        HashMap metaValues = new HashMap();
        try {
            if (this.metaDataFile.getAbsolutePath().endsWith(".fam")) {
                for (String line : new XReadLines(this.metaDataFile)) {
                    this.outFam.printf("%s%n", line);
                }
            } else {
                for (String line : new XReadLines(this.metaDataFile)) {
                    String[] split = line.split("\\t");
                    String sampleID = split[0];
                    String keyVals = split[1];
                    HashMap<String, String> values = new HashMap<String, String>();
                    for (String kvp : keyVals.split(";")) {
                        String[] kvp_split = kvp.split("=");
                        values.put(kvp_split[0], kvp_split[1]);
                    }
                    metaValues.put(sampleID, values);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new UserException("Meta data file not found: " + this.metaDataFile.getAbsolutePath(), e);
        }
        int dummyID = 0;
        Map<String, VCFHeader> headers = VCFUtils.getVCFHeadersFromRods(this.getToolkit());
        for (Map.Entry<String, VCFHeader> header : headers.entrySet()) {
            if (!header.getKey().equals(this.variantCollection.variants.getName()) && !this.metaDataFile.getAbsolutePath().endsWith(".fam")) continue;
            for (String sample : header.getValue().getGenotypeSamples()) {
                Map mVals = (Map)metaValues.get(sample);
                if (mVals == null) {
                    throw new UserException("No metadata provided for sample " + sample);
                }
                if (!mVals.containsKey("phenotype")) {
                    throw new UserException("No phenotype data provided for sample " + sample);
                }
                String fid = mVals.containsKey("fid") ? (String)mVals.get("fid") : String.format("dummy_%d", ++dummyID);
                String pid = mVals.containsKey("dad") ? (String)mVals.get("dad") : String.format("dummy_%d", ++dummyID);
                String mid = mVals.containsKey("mom") ? (String)mVals.get("mom") : String.format("dummy_%d", ++dummyID);
                String sex = mVals.containsKey("sex") ? (String)mVals.get("sex") : "3";
                String pheno = (String)mVals.get("phenotype");
                this.outFam.printf("%s\t%s\t%s\t%s\t%s\t%s%n", fid, sample, pid, mid, sex, pheno);
            }
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null || !tracker.hasValues(this.variantCollection.variants) || tracker.getFirstValue(this.variantCollection.variants).isFiltered() || !tracker.getFirstValue(this.variantCollection.variants).isSNP() || !tracker.getFirstValue(this.variantCollection.variants).isBiallelic()) {
            return 0;
        }
        try {
            this.vv.map(tracker, ref, context);
        }
        catch (UserException e) {
            throw new UserException("Input VCF file is invalid; we cannot guarantee the resulting ped file. Please run ValidateVariants for more detailed information.");
        }
        VariantContext vc = tracker.getFirstValue(this.variantCollection.variants);
        this.outBim.printf("%s\t%s\t%.2f\t%d\t%s\t%s%n", vc.getChr(), VariantsToPed.getID(vc), APPROX_CM_PER_BP * (double)vc.getStart(), vc.getStart(), vc.getReference().getBaseString(), vc.getAlternateAllele(0).getBaseString());
        int buf = 0;
        int idx = 0;
        byte out = 0;
        byte[] toWrite = new byte[1 + vc.getNSamples() / 4];
        for (Genotype g : vc.getGenotypes()) {
            out = (byte)(out | this.getEncoding(g, buf));
            if (buf == 3) {
                toWrite[idx] = out;
                buf = 0;
                out = 0;
                ++idx;
                continue;
            }
            ++buf;
        }
        if (out != 0) {
            toWrite[idx] = out;
        }
        try {
            this.outBed.write(toWrite);
        }
        catch (IOException e) {
            throw new ReviewedStingException("Error writing to output file");
        }
        return 1;
    }

    @Override
    public Integer reduce(Integer m, Integer r) {
        return r + m;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    private byte getEncoding(Genotype g, int offset) {
        int b = g.hasAttribute("GQ") && (Integer)g.getAttribute("GQ") < this.minGenotypeQuality ? 1 : (g.isHomRef() ? 0 : (g.isHomVar() ? 3 : (g.isHet() ? 2 : 1)));
        return (byte)(b << 2 * offset);
    }

    private static String getID(VariantContext v) {
        if (v.hasID()) {
            return v.getID();
        }
        return String.format("SNP-%s-%d", v.getChr(), v.getStart());
    }
}

