/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class Haplotype {
    protected final byte[] bases;
    protected final double[] quals;
    private GenomeLoc genomeLocation = null;
    private boolean isReference = false;

    public Haplotype(byte[] bases, int qual) {
        this.bases = bases;
        this.quals = new double[bases.length];
        Arrays.fill(this.quals, (double)qual);
    }

    public Haplotype(byte[] bases, double[] quals) {
        this.bases = bases;
        this.quals = quals;
    }

    public Haplotype(byte[] bases) {
        this(bases, 0);
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases);
        this.genomeLocation = loc;
    }

    public Haplotype(byte[] bases, GenomeLoc loc, boolean isRef) {
        this(bases, loc);
        this.isReference = isRef;
    }

    public boolean equals(Object h) {
        return h instanceof Haplotype && Arrays.equals(this.bases, ((Haplotype)h).bases);
    }

    public double getQualitySum() {
        double s = 0.0;
        for (int k = 0; k < this.bases.length; ++k) {
            s += this.quals[k];
        }
        return s;
    }

    public String toString() {
        String returnString = "";
        for (int iii = 0; iii < this.bases.length; ++iii) {
            returnString = returnString + (char)this.bases[iii];
        }
        return returnString;
    }

    public double[] getQuals() {
        return this.quals;
    }

    public byte[] getBases() {
        return this.bases;
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public boolean isReference() {
        return this.isReference;
    }

    @Requires(value={"refInsertLocation >= 0", "hapStartInRefCoords >= 0"})
    public byte[] insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation, int hapStartInRefCoords, Cigar haplotypeCigar) {
        byte[] newHaplotype;
        int haplotypeInsertLocation;
        if (refAllele.length() != altAllele.length()) {
            ++refInsertLocation;
        }
        if ((haplotypeInsertLocation = Haplotype.getHaplotypeCoordinateForReferenceCoordinate(hapStartInRefCoords, haplotypeCigar, refInsertLocation).intValue()) == -1) {
            return (byte[])this.bases.clone();
        }
        try {
            if (refAllele.length() == altAllele.length()) {
                newHaplotype = (byte[])this.bases.clone();
                for (int iii = 0; iii < altAllele.length(); ++iii) {
                    newHaplotype[haplotypeInsertLocation + iii] = altAllele.getBases()[iii];
                }
            } else if (refAllele.length() < altAllele.length()) {
                int iii;
                int altAlleleLength = altAllele.length();
                newHaplotype = new byte[this.bases.length + altAlleleLength];
                for (iii = 0; iii < this.bases.length; ++iii) {
                    newHaplotype[iii] = this.bases[iii];
                }
                for (iii = newHaplotype.length - 1; iii > haplotypeInsertLocation + altAlleleLength - 1; --iii) {
                    newHaplotype[iii] = newHaplotype[iii - altAlleleLength];
                }
                for (iii = 0; iii < altAlleleLength; ++iii) {
                    newHaplotype[haplotypeInsertLocation + iii] = altAllele.getBases()[iii];
                }
            } else {
                int iii;
                int shift = refAllele.length() - altAllele.length();
                newHaplotype = new byte[this.bases.length - shift];
                for (iii = 0; iii < haplotypeInsertLocation + altAllele.length(); ++iii) {
                    newHaplotype[iii] = this.bases[iii];
                }
                for (iii = haplotypeInsertLocation + altAllele.length(); iii < newHaplotype.length; ++iii) {
                    newHaplotype[iii] = this.bases[iii + shift];
                }
            }
        }
        catch (Exception e) {
            return (byte[])this.bases.clone();
        }
        return newHaplotype;
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a : alleleList) {
            if (!a.isReference()) continue;
            refAllele = a;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        byte[] basesBeforeVariant = Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases);
        int startAfter = startIdxInReference + numPrefBases + refAllele.getBases().length;
        if (startAfter > refBases.length) {
            startAfter = refBases.length;
        }
        byte[] basesAfterVariant = Arrays.copyOfRange(refBases, startAfter, refBases.length);
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a : alleleList) {
            byte[] alleleBases = a.getBases();
            String haplotypeString = new String(basesBeforeVariant) + new String(alleleBases) + new String(basesAfterVariant);
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a, new Haplotype(haplotypeString.getBytes(), locus, a.isReference()));
        }
        return haplotypeMap;
    }

    private static Integer getHaplotypeCoordinateForReferenceCoordinate(int haplotypeStart, Cigar haplotypeCigar, int refCoord) {
        int readBases = 0;
        int refBases = 0;
        boolean fallsInsideDeletion = false;
        int goal = refCoord - haplotypeStart;
        boolean goalReached = refBases == goal;
        Iterator<CigarElement> cigarElementIterator = haplotypeCigar.getCigarElements().iterator();
        while (!goalReached && cigarElementIterator.hasNext()) {
            boolean endsWithinCigar;
            CigarElement cigarElement = cigarElementIterator.next();
            int shift = 0;
            if (cigarElement.getOperator().consumesReferenceBases() || cigarElement.getOperator() == CigarOperator.SOFT_CLIP) {
                shift = refBases + cigarElement.getLength() < goal ? cigarElement.getLength() : goal - refBases;
                refBases += shift;
            }
            boolean bl = goalReached = refBases == goal;
            if (!goalReached && cigarElement.getOperator().consumesReadBases()) {
                readBases += cigarElement.getLength();
            }
            if (!goalReached) continue;
            boolean bl2 = endsWithinCigar = shift < cigarElement.getLength();
            if (!endsWithinCigar && !cigarElementIterator.hasNext()) {
                return -1;
            }
            if (endsWithinCigar) {
                fallsInsideDeletion = cigarElement.getOperator() == CigarOperator.DELETION;
            } else {
                CigarElement nextCigarElement = cigarElementIterator.next();
                if (nextCigarElement.getOperator() == CigarOperator.INSERTION) {
                    readBases += nextCigarElement.getLength();
                    if (!cigarElementIterator.hasNext()) {
                        return -1;
                    }
                    nextCigarElement = cigarElementIterator.next();
                }
                boolean bl3 = fallsInsideDeletion = nextCigarElement.getOperator() == CigarOperator.DELETION;
            }
            if (!fallsInsideDeletion && cigarElement.getOperator().consumesReadBases()) {
                readBases += shift;
                continue;
            }
            if (fallsInsideDeletion && !endsWithinCigar) {
                readBases += shift - 1;
                continue;
            }
            if (!fallsInsideDeletion || !endsWithinCigar) continue;
            --readBases;
        }
        if (!goalReached) {
            return -1;
        }
        return fallsInsideDeletion ? -1 : readBases;
    }
}

