/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.walkers.qc.DocumentationTest;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeatureHandler;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeatureObject;
import org.broadinstitute.sting.utils.help.GATKDocWorkUnit;
import org.broadinstitute.sting.utils.help.GenericDocumentationHandler;
import org.broadinstitute.sting.utils.help.HelpUtils;

public class GATKDoclet {
    protected static final Logger logger = Logger.getLogger(GATKDoclet.class);
    protected static final File SETTINGS_DIR = new File("settings/helpTemplates");
    protected static final File DESTINATION_DIR = new File("gatkdocs");
    protected static String buildTimestamp = null;
    protected static String absoluteVersion = null;
    protected static boolean showHiddenFeatures = false;
    protected static boolean testOnly = false;
    private static final List<Class<?>> testOnlyKeepers = Arrays.asList(DocumentationTest.class, CommandLineGATK.class, UserException.class);
    RootDoc rootDoc;
    Set<GATKDocWorkUnit> myWorkUnits;
    static final Collection<DocumentedGATKFeatureObject> STATIC_DOCS = new ArrayList<DocumentedGATKFeatureObject>();

    public static boolean start(RootDoc rootDoc) throws IOException {
        logger.setLevel(Level.INFO);
        for (String[] options : rootDoc.options()) {
            if (options[0].equals("-build-timestamp")) {
                buildTimestamp = options[1];
            }
            if (options[0].equals("-absolute-version")) {
                absoluteVersion = options[1];
            }
            if (options[0].equals("-include-hidden")) {
                showHiddenFeatures = true;
            }
            if (!options[0].equals("-test")) continue;
            testOnly = true;
        }
        new GATKDoclet().processDocs(rootDoc);
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-build-timestamp") || option.equals("-absolute-version") || option.equals("-include-hidden")) {
            return 2;
        }
        if (option.equals("-test")) {
            return 1;
        }
        return 0;
    }

    public boolean showHiddenFeatures() {
        return showHiddenFeatures;
    }

    private void processDocs(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        try {
            DESTINATION_DIR.mkdirs();
            FileUtils.copyFile(new File(SETTINGS_DIR + "/style.css"), new File(DESTINATION_DIR + "/style.css"));
            Configuration cfg = new Configuration();
            cfg.setDirectoryForTemplateLoading(SETTINGS_DIR);
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            this.myWorkUnits = this.computeWorkUnits();
            for (GATKDocWorkUnit workUnit : this.myWorkUnits) {
                this.processDocWorkUnit(cfg, workUnit);
            }
            this.processIndex(cfg, new ArrayList<GATKDocWorkUnit>(this.myWorkUnits));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<GATKDocWorkUnit> computeWorkUnits() {
        TreeSet<GATKDocWorkUnit> m = new TreeSet<GATKDocWorkUnit>();
        for (ClassDoc doc : this.rootDoc.classes()) {
            DocumentedGATKFeatureObject feature;
            DocumentedGATKFeatureHandler handler;
            Class<? extends Object> clazz = this.getClassForClassDoc(doc);
            if (clazz != null && testOnly && !testOnlyKeepers.contains(clazz) || (handler = this.createHandler(doc, feature = this.getFeatureForClassDoc(doc))) == null || !handler.includeInDocs(doc)) continue;
            logger.info("Generating documentation for class " + doc);
            String filename = handler.getDestinationFilename(doc, clazz);
            GATKDocWorkUnit unit = new GATKDocWorkUnit(doc.name(), filename, feature.groupName(), feature, handler, doc, clazz, buildTimestamp, absoluteVersion);
            m.add(unit);
        }
        return m;
    }

    private DocumentedGATKFeatureHandler createHandler(ClassDoc doc, DocumentedGATKFeatureObject feature) {
        if (feature != null) {
            if (feature.enable()) {
                GenericDocumentationHandler handler = new GenericDocumentationHandler();
                handler.setDoclet(this);
                return handler;
            }
            logger.info("Skipping disabled Documentation for " + doc);
        }
        return null;
    }

    private DocumentedGATKFeatureObject getFeatureForClassDoc(ClassDoc doc) {
        Class<? extends Object> docClass = this.getClassForClassDoc(doc);
        if (docClass == null) {
            return null;
        }
        if (docClass.isAnnotationPresent(DocumentedGATKFeature.class)) {
            DocumentedGATKFeature f = docClass.getAnnotation(DocumentedGATKFeature.class);
            return new DocumentedGATKFeatureObject(docClass, f.enable(), f.groupName(), f.summary(), f.extraDocs());
        }
        for (DocumentedGATKFeatureObject staticDocs : STATIC_DOCS) {
            if (!staticDocs.getClassToDoc().isAssignableFrom(docClass)) continue;
            return new DocumentedGATKFeatureObject(docClass, staticDocs.enable(), staticDocs.groupName(), staticDocs.summary(), staticDocs.extraDocs());
        }
        return null;
    }

    private Class<? extends Object> getClassForClassDoc(ClassDoc doc) {
        try {
            return HelpUtils.getClassForDoc((ProgramElementDoc)doc);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    private void processIndex(Configuration cfg, List<GATKDocWorkUnit> indexData) throws IOException {
        Template temp = cfg.getTemplate("generic.index.template.html");
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(DESTINATION_DIR + "/index.html")));
        try {
            temp.process(this.groupIndexData(indexData), out);
            ((Writer)out).flush();
        }
        catch (TemplateException e) {
            throw new ReviewedStingException("Failed to create GATK documentation", e);
        }
    }

    private Map<String, Object> groupIndexData(List<GATKDocWorkUnit> indexData) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Collections.sort(indexData);
        ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
        HashSet<String> seenDocumentationFeatures = new HashSet<String>();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (GATKDocWorkUnit workUnit : indexData) {
            data.add(workUnit.indexDataMap());
            if (seenDocumentationFeatures.contains(workUnit.annotation.groupName())) continue;
            groups.add(GATKDoclet.toMap(workUnit.annotation));
            seenDocumentationFeatures.add(workUnit.annotation.groupName());
        }
        root.put("data", data);
        root.put("groups", groups);
        root.put("timestamp", buildTimestamp);
        root.put("version", absoluteVersion);
        return root;
    }

    private static final Map<String, String> toMap(DocumentedGATKFeatureObject annotation) {
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("name", annotation.groupName());
        root.put("summary", annotation.summary());
        return root;
    }

    public final GATKDocWorkUnit findWorkUnitForClass(Class c) {
        for (GATKDocWorkUnit unit : this.myWorkUnits) {
            if (!unit.clazz.equals(c)) continue;
            return unit;
        }
        return null;
    }

    public ClassDoc getClassDocForClass(Class clazz) {
        return this.rootDoc.classNamed(clazz.getName());
    }

    private void processDocWorkUnit(Configuration cfg, GATKDocWorkUnit unit) throws IOException {
        unit.handler.processOne(unit);
        Template temp = cfg.getTemplate(unit.handler.getTemplateName(unit.classDoc));
        File outputPath = new File(DESTINATION_DIR + "/" + unit.filename);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputPath));
            temp.process(unit.forTemplate, out);
            ((Writer)out).flush();
        }
        catch (TemplateException e) {
            throw new ReviewedStingException("Failed to create GATK documentation", e);
        }
    }

    static {
        STATIC_DOCS.add(new DocumentedGATKFeatureObject(FeatureCodec.class, "Reference ordered data (ROD) codecs", "Tribble codecs for reading reference ordered data such as VCF or BED files"));
    }
}

