# Filename: vcf2genotypes.py
# Author: Shuai Yuan
# Version: 06/29/2012
#
# This script is a wrapper for vcf2genotypes
#
#  vcf2genotypes is launched based on these inputs:
#  -i		input VCF file
#  -p		target individual
#  -o		output genotypes file

import sys
import os
import re
import string
import commands
from tempfile import NamedTemporaryFile

# This function is exceedingly useful, perhaps package for reuse?
def getopts(argv):
    opts = {}
    while argv:
	if argv[0][0] == '-':
	    opts[argv[0]] = argv[1]
	    argv = argv[2:]
	else:
	    argv = argv[1:]
    return opts

def main():
    args = sys.argv[1:]

    try:
	opts = getopts(args)
    except IndexError:
	print "Usage:"
	return 0

    vcf = opts.get("-i")
    if vcf == None:
        print "No input VCF file specified."
        return -1
    
    individual = opts.get("-p")
    if individual == None:
        print "No valid individual specified."
        return -2

    outputfile = opts.get("-o")
    if outputfile == None:
        print "No output file specified."
        return -6
 

# All inputs have been specified at this point, now validate.
	
    #generate command
    commandline = "vcf2genotypes %s  %s >  %s " % (vcf, individual, outputfile)
    #run
    errorcode, stdout = commands.getstatusoutput(commandline)
    
    #return error code
    return errorcode

if __name__ == "__main__":
    main()
