# Filename: DiploidConstructor.py
# Author: Shuai Yuan
# Version: 05/27/2012
#
# This script is a wrapper for DiploidConstructor
#
# DiploidConstructor is launched based on these inputs:
#  -r		haploid reference genome file 
#  -g		genotypes file
#  -l		read length
#  -d		maximal deletion in a read and mapped to alternative alleles [default=0]
#  -s		sex of the individual [default="m"]
#  -o		output diploid reference genome file 

import sys
import os
import re
import string
import commands
from tempfile import NamedTemporaryFile

# This function is exceedingly useful, perhaps package for reuse?
def getopts(argv):
    opts = {}
    while argv:
	if argv[0][0] == '-':
	    opts[argv[0]] = argv[1]
	    argv = argv[2:]
	else:
	    argv = argv[1:]
    return opts

def main():
    args = sys.argv[1:]

    try:
	opts = getopts(args)
    except IndexError:
	print "Usage:"
	return 0

    hg19 = opts.get("-r")
    if hg19 == None:
        print "No reference file specified."
        return -1
    
    genotypes = opts.get("-g")
    if genotypes == None:
        print "No genotypes file specified."
        return -2

    length = opts.get("-l")
    if length == None:
        print "No read length specified."
        return -3

    indel = opts.get("-d")
    if indel == None:
        print "No max deletion specified."
        return -4

    gender = opts.get("-d")
    if gender == None:
        print "No gender specified."
        return -5

    outputfile = opts.get("-o")
    if outputfile == None:
        print "No output file specified."
        return -6
 

# All inputs have been specified at this point, now validate.
	
    #generate command
    commandline = "DiploidConstructor -r %s -g %s -l %s -d %s -s %s -o %s " % (hg19, genotypes, length, indel, gender, outputfile)
    #run 
    errorcode, stdout = commands.getstatusoutput(commandline)
    
    #return error code
    return errorcode

if __name__ == "__main__":
    main()
