#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt;


GetOptions(\%opt, "gtf=s","po=s","version","mo=s","count=i","chromfile=s","t=s","iCLIP","track","name=s","description=s","color=s","s=s","id=s");

my $cmnd;
my $prefix = "gb_$opt{id}";
$prefix =~ s/\s/_/g;


if (exists $opt{version}){
	$cmnd = "python /usr/local/bin/pyGTF2bedGraph.py --version";
}
else{
	$cmnd = "python /usr/local/bin/pyGTF2bedGraph.py --gtf $opt{gtf} --chromfile $opt{chromfile} -t $opt{t} --count $opt{count} -o $prefix";

	if(exists $opt{iCLIP}){

	    $cmnd .= " --iCLIP";
	}

	if(exists $opt{track}){
	    $cmnd .= " --track --name \"$opt{name}\" --description \"$opt{description}\"";
	    
	    if(exists $opt{color}){$cmnd .= " --color $opt{color}";}
            if(exists $opt{s}){$cmnd .= " -s \"$opt{s}\"";}
	}
}

system $cmnd;

system "mv $prefix"."_plus_strand.bedgraph $opt{po}";
system "mv $prefix"."_minus_strand.bedgraph $opt{mo}";

