#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt;


GetOptions(\%opt, "f=s","version","gtf=s","range=i","overlap=i","--annotation=s", "--tab=s","--k_min=i","--k_max=i","--numberofkmers=i","--count=s","--features=s","--zscores=s","--random=s","options","o=s","id=s");

my $cmnd;

my $prefix = "m_$opt{id}";


if (exists $opt{version}){
	$cmnd = "python /usr/local/bin/pyMotif.py --version";
}
else{
	$cmnd = "python /usr/local/bin/pyMotif.py -f $opt{f} --gtf $opt{gtf} --tab $opt{tab} --annotation $opt{annotation} -o $prefix";

	if(exists $opt{options}){

	    $cmnd .= " --range=$opt{range} --overlap=$opt{overlap} --k_min=$opt{k_min} --k_max=$opt{k_max} --numberofkmers=$opt{numberofkmers}";
	}
}

#testing
#open (COUNT, ">$opt{count}") || die "";
#print COUNT "$cmnd";

system $cmnd;


system "mv $prefix"."_$opt{annotation}_data_k-mers_count.txt $opt{count}";
system "mv $prefix"."_$opt{annotation}_top_k-mers_in_features.gtf $opt{features}";
system "mv $prefix"."_$opt{annotation}_k-mer_Z_scores.txt $opt{zscores}";
system "mv $prefix"."_$opt{annotation}_random_k-mers_count.txt $opt{random}";
    



