require("ChIPseeker", quietly = TRUE)
require("ChIPpeakAnno", quietly = TRUE)
require("org.Hs.eg.db", quietly = TRUE)
options(warn = -1)

args <- commandArgs(trailingOnly = TRUE)
DMR = args[1]
annoPeakTable = args[2]


DMRInfo = read.table(
  DMR,
  header = FALSE,
  sep = "\t",
  stringsAsFactors = FALSE,
  quote = ""
)

DMRPeaks <- GRanges(seqnames = DMRInfo[, 1],
                    ranges = IRanges
                    (start = DMRInfo[, 2], end = DMRInfo[, 3]))

annotatePeak <-
  as.data.frame(annotatePeak(DMRPeaks, level = "gene", annoDb = "org.Hs.eg.db"))
??org.Hs.eg.db

write.csv(annotatePeak, annoPeakTable, row.names = FALSE)
