options("download.file.method.GEOquery"="wget")
options(warn = -1)

args <- commandArgs(trailingOnly = TRUE)
GSMTable = args[1]
protocol = args[2]
platform = args[3]
Data_Table = args[4]

TAB = fread(GSMTable)

if (is.null(TAB)) {
  stop("Must specify input files")
} else {
  GEODataTable <- getGEO(TAB$ID[1], getGPL = FALSE)
  IlmnIDTable <- Table(GEODataTable)
  MetaData <- data.frame(Meta(GEODataTable))


  write.table(MetaData, protocol, row.names = FALSE, sep = "\t")
}

hm450.hg19 <- getPlatform()

IlmnInfo <-
  data.table(
    IlmnID = names(hm450.hg19),
    CHR = as.data.frame(hm450.hg19@seqnames)$value,
    BP = as.numeric(hm450.hg19@elementMetadata$probeStart)
  )


write.table(IlmnInfo, platform, row.names = FALSE, sep = "\t")


if (length(TAB$ID) > 1) {
  mysamples <-
    do.call("data.table", lapply(TAB$ID[-1], function(x)
      Table(getGEO(x, getGPL = FALSE))[, -1]))

  gmSet <- data.table(IlmnIDTable[, -1], mysamples)

} else {
  gmSet <- Table(getGEO(TAB$ID, getGPL = FALSE))
}

write.table(gmSet, Data_Table, row.names = FALSE,quote=FALSE,sep="\t")

