require("rentrez", quietly = TRUE)

args <- commandArgs(trailingOnly = TRUE)

GSE = args[1]
GSMTable = args[2]



search1 <- entrez_search(db = "gds", term = GSE, retmax = 1)

rec2 <- entrez_summary(db = "gds",
                       id = search1$ids,
                       version = "2.0")

extract <- extract_from_esummary(rec2,rownames(summary(rec2)))

samples <- extract$samples
colnames(samples)[which(names(samples) == "accession")] <- "ID"
colnames(samples)[which(names(samples) == "title")] <-  "Phenotype"

samples$Phenotype<-gsub("\\s", "",samples$Phenotype) 

write.table(samples, GSMTable, row.names = FALSE,quote=FALSE,sep="\t")


