/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

public abstract class AbstractCollectionConverter
implements Converter {
    private final Mapper mapper;
    protected ClassMapper classMapper;
    protected String classAttributeIdentifier;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$Null;

    public abstract boolean canConvert(Class var1);

    public AbstractCollectionConverter(ClassMapper classMapper, String classAttributeIdentifier) {
        this.classMapper = classMapper;
        this.classAttributeIdentifier = classAttributeIdentifier;
        this.mapper = classMapper;
    }

    public AbstractCollectionConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    protected Mapper mapper() {
        return this.mapper;
    }

    public abstract void marshal(Object var1, HierarchicalStreamWriter var2, MarshallingContext var3);

    public abstract Object unmarshal(HierarchicalStreamReader var1, UnmarshallingContext var2);

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (item == null) {
            writer.startNode(this.mapper().serializedClass(class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = AbstractCollectionConverter.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null));
            writer.endNode();
        } else {
            writer.startNode(this.mapper().serializedClass(item.getClass()));
            context.convertAnother(item);
            writer.endNode();
        }
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        String classAttribute = reader.getAttribute(this.mapper().attributeForImplementationClass());
        Class type = classAttribute == null ? this.mapper().realClass(reader.getNodeName()) : this.mapper().realClass(classAttribute);
        return context.convertAnother(current, type);
    }

    protected Object createCollection(Class type) {
        Class defaultType = this.mapper().defaultImplementationOf(type);
        try {
            return defaultType.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConversionException("Cannot instantiate " + defaultType.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Cannot instantiate " + defaultType.getName(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

