/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDCT_1D {
    private int n;
    private int[] ip;
    private float[] w;
    private int nw;
    private int nc;
    private boolean isPowerOfTwo = false;
    private FloatFFT_1D fft;
    private static final double PI = Math.PI;

    public FloatDCT_1D(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n;
        if (ConcurrencyUtils.isPowerOf2(n)) {
            this.isPowerOfTwo = true;
            this.ip = new int[(int)Math.ceil(2 + (1 << (int)(Math.log((double)(n / 2) + 0.5) / Math.log(2.0)) / 2))];
            this.w = new float[n * 5 / 4];
            this.nw = this.ip[0];
            if (n > this.nw << 2) {
                this.nw = n >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n > this.nc) {
                this.nc = n;
                this.makect(this.nc, this.w, this.nw);
            }
        } else {
            this.w = this.makect(n);
            this.fft = new FloatFFT_1D(2 * n);
        }
    }

    public void forward(float[] fArray, boolean bl) {
        this.forward(fArray, 0, bl);
    }

    public void forward(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            float f = fArray[n + this.n - 1];
            for (int i = this.n - 2; i >= 2; i -= 2) {
                fArray[n + i + 1] = fArray[n + i] - fArray[n + i - 1];
                int n2 = n + i;
                fArray[n2] = fArray[n2] + fArray[n + i - 1];
            }
            fArray[n + 1] = fArray[n] - f;
            int n3 = n;
            fArray[n3] = fArray[n3] + f;
            if (this.n > 4) {
                this.rftbsub(this.n, fArray, n, this.nc, this.w, this.nw);
                this.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                this.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
            }
            this.dctsub(this.n, fArray, n, this.nc, this.w, this.nw);
            if (bl) {
                this.scale((float)Math.sqrt(2.0 / (double)this.n), fArray, n);
                fArray[n] = (float)((double)fArray[n] / Math.sqrt(2.0));
            }
        } else {
            int n4;
            int n5 = 2 * this.n;
            final float[] fArray2 = new float[n5];
            System.arraycopy(fArray, n, fArray2, 0, this.n);
            int n6 = ConcurrencyUtils.getNumberOfThreads();
            for (n4 = this.n; n4 < n5; ++n4) {
                fArray2[n4] = fArray2[n5 - n4 - 1];
            }
            this.fft.realForward(fArray2);
            if (n6 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n6 = 2;
                n4 = this.n / n6;
                Future[] futureArray = new Future[n6];
                for (int i = 0; i < n6; ++i) {
                    final int n7 = i * n4;
                    final int n8 = i == n6 - 1 ? this.n : n7 + n4;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n3 = 2 * i;
                                int n2 = n + i;
                                fArray[n2] = FloatDCT_1D.this.w[n3] * fArray2[n3] - FloatDCT_1D.this.w[n3 + 1] * fArray2[n3 + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (n4 = 0; n4 < this.n; ++n4) {
                    int n9 = 2 * n4;
                    int n10 = n + n4;
                    fArray[n10] = this.w[n9] * fArray2[n9] - this.w[n9 + 1] * fArray2[n9 + 1];
                }
            }
            if (bl) {
                this.scale((float)(1.0 / Math.sqrt(n5)), fArray, n);
                fArray[n] = (float)((double)fArray[n] / Math.sqrt(2.0));
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            if (bl) {
                this.scale((float)Math.sqrt(2.0 / (double)this.n), fArray, n);
                fArray[n] = (float)((double)fArray[n] / Math.sqrt(2.0));
            }
            this.dctsub(this.n, fArray, n, this.nc, this.w, this.nw);
            if (this.n > 4) {
                this.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
                this.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                this.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
            }
            float f = fArray[n] - fArray[n + 1];
            int n2 = n;
            fArray[n2] = fArray[n2] + fArray[n + 1];
            for (int i = 2; i < this.n; i += 2) {
                fArray[n + i - 1] = fArray[n + i] - fArray[n + i + 1];
                int n3 = n + i;
                fArray[n3] = fArray[n3] + fArray[n + i + 1];
            }
            fArray[n + this.n - 1] = f;
        } else {
            int n4 = 2 * this.n;
            if (bl) {
                this.scale((float)Math.sqrt(n4), fArray, n);
                fArray[n] = (float)((double)fArray[n] * Math.sqrt(2.0));
            }
            final float[] fArray2 = new float[n4];
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                int n6 = this.n / n5;
                Future[] futureArray = new Future[n5];
                for (int i = 0; i < n5; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n5 - 1 ? this.n : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n2 = 2 * i;
                                float f = fArray[n + i];
                                fArray2[n2] = FloatDCT_1D.this.w[n2] * f;
                                fArray2[n2 + 1] = -FloatDCT_1D.this.w[n2 + 1] * f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int n9 = 2 * i;
                    float f = fArray[n + i];
                    fArray2[n9] = this.w[n9] * f;
                    fArray2[n9 + 1] = -this.w[n9 + 1] * f;
                }
            }
            this.fft.realInverse(fArray2, true);
            System.arraycopy(fArray2, 0, fArray, n, this.n);
        }
    }

    private float[] makect(int n) {
        int n2 = 2 * n;
        double d = Math.PI / (double)n2;
        float[] fArray = new float[n2];
        fArray[0] = 1.0f;
        for (int i = 1; i < n; ++i) {
            int n3 = 2 * i;
            double d2 = d * (double)i;
            fArray[n3] = (float)Math.cos(d2);
            fArray[n3 + 1] = (float)(-Math.sin(d2));
        }
        return fArray;
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            double d2 = d * 2.0;
            float f = (float)Math.cos(d * (double)n3);
            this.w[0] = 1.0f;
            this.w[1] = f;
            if (n3 == 4) {
                this.w[2] = (float)Math.cos(d2);
                this.w[3] = (float)Math.sin(d2);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = (float)(0.5 / Math.cos(d2));
                this.w[3] = (float)(0.5 / Math.cos(d * 6.0));
                for (n2 = 4; n2 < n3; n2 += 4) {
                    double d3 = d * (double)n2;
                    double d4 = 3.0 * d3;
                    this.w[n2] = (float)Math.cos(d3);
                    this.w[n2 + 1] = (float)Math.sin(d3);
                    this.w[n2 + 2] = (float)Math.cos(d4);
                    this.w[n2 + 3] = (float)(-Math.sin(d4));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f2;
                float f3;
                int n5 = n4 + n3;
                this.w[n5] = 1.0f;
                this.w[n5 + 1] = f;
                if ((n3 >>= 1) == 4) {
                    f3 = this.w[n4 + 4];
                    f2 = this.w[n4 + 5];
                    this.w[n5 + 2] = f3;
                    this.w[n5 + 3] = f2;
                } else if (n3 > 4) {
                    f3 = this.w[n4 + 4];
                    float f4 = this.w[n4 + 6];
                    this.w[n5 + 2] = (float)(0.5 / (double)f3);
                    this.w[n5 + 3] = (float)(0.5 / (double)f4);
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f3 = this.w[n6];
                        f2 = this.w[n6 + 1];
                        f4 = this.w[n6 + 2];
                        float f5 = this.w[n6 + 3];
                        this.w[n7] = f3;
                        this.w[n7 + 1] = f2;
                        this.w[n7 + 2] = f4;
                        this.w[n7 + 3] = f5;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, float[] fArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            fArray[n2] = (float)Math.cos(d * (double)n3);
            fArray[n2 + n3] = (float)(0.5 * (double)fArray[n2]);
            for (int i = 1; i < n3; ++i) {
                double d2 = d * (double)i;
                fArray[n2 + i] = (float)(0.5 * Math.cos(d2));
                fArray[n2 + n - i] = (float)(0.5 * Math.sin(d2));
            }
        }
    }

    private void cftfsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftf1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    this.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    this.cftfx41(n, fArray, n2, n3, fArray2);
                }
                this.bitrv2(n, nArray, fArray, n2);
            } else if (n == 32) {
                this.cftf161(fArray, n2, fArray2, n3 - 8);
                this.bitrv216(fArray, n2);
            } else {
                this.cftf081(fArray, n2, fArray2, 0);
                this.bitrv208(fArray, n2);
            }
        } else if (n == 8) {
            this.cftf040(fArray, n2);
        } else if (n == 4) {
            this.cftx020(fArray, n2);
        }
    }

    private void cftbsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftb1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    this.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    this.cftfx41(n, fArray, n2, n3, fArray2);
                }
                this.bitrv2conj(n, nArray, fArray, n2);
            } else if (n == 32) {
                this.cftf161(fArray, n2, fArray2, n3 - 8);
                this.bitrv216neg(fArray, n2);
            } else {
                this.cftf081(fArray, n2, fArray2, 0);
                this.bitrv208neg(fArray, n2);
            }
        } else if (n == 8) {
            this.cftb040(fArray, n2);
        } else if (n == 4) {
            this.cftx020(fArray, n2);
        }
    }

    private void bitrv2(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = 4 * i + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = 4 * i + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n11;
                int n12;
                int n13;
                int n14;
                for (int j = 0; j < i; ++j) {
                    n14 = 4 * j + nArray[n4 + i];
                    n13 = 4 * i + nArray[n4 + j];
                    n12 = n2 + n14;
                    n11 = n2 + n13;
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n5);
                    n11 = n2 + (n13 += 2);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += 2);
                    n11 = n2 + (n13 += n5);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n5);
                    n11 = n2 + (n13 -= 2);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    f7 = fArray[n12];
                    f6 = fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                }
                n13 = 4 * i + nArray[n4 + i];
                n14 = n13 + 2;
                n12 = n2 + n14;
                n11 = n2 + (n13 += n5);
                f7 = fArray[n12];
                f6 = fArray[n12 + 1];
                f5 = fArray[n11];
                f = fArray[n11 + 1];
                fArray[n12] = f5;
                fArray[n12 + 1] = f;
                fArray[n11] = f7;
                fArray[n11 + 1] = f6;
                n12 = n2 + (n14 += n6);
                n11 = n2 + (n13 += n6);
                f7 = fArray[n12];
                f6 = fArray[n12 + 1];
                f5 = fArray[n11];
                f = fArray[n11 + 1];
                fArray[n12] = f5;
                fArray[n12 + 1] = f;
                fArray[n11] = f7;
                fArray[n11 + 1] = f6;
            }
        }
    }

    private void bitrv2conj(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = 4 * i + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = 4 * i + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n11;
                int n12;
                int n13;
                int n14;
                for (int j = 0; j < i; ++j) {
                    n14 = 4 * j + nArray[n4 + i];
                    n13 = 4 * i + nArray[n4 + j];
                    n12 = n2 + n14;
                    n11 = n2 + n13;
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n5);
                    n11 = n2 + (n13 += 2);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += 2);
                    n11 = n2 + (n13 += n5);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 += n6);
                    n11 = n2 + (n13 += n6);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n5);
                    n11 = n2 + (n13 -= 2);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                    n12 = n2 + (n14 -= n6);
                    n11 = n2 + (n13 -= n6);
                    f7 = fArray[n12];
                    f6 = -fArray[n12 + 1];
                    f5 = fArray[n11];
                    f = -fArray[n11 + 1];
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f;
                    fArray[n11] = f7;
                    fArray[n11 + 1] = f6;
                }
                n13 = 4 * i + nArray[n4 + i];
                n14 = n13 + 2;
                n12 = n2 + n14;
                n11 = n2 + (n13 += n5);
                fArray[n12 - 1] = -fArray[n12 - 1];
                f7 = fArray[n12];
                f6 = -fArray[n12 + 1];
                f5 = fArray[n11];
                f = -fArray[n11 + 1];
                fArray[n12] = f5;
                fArray[n12 + 1] = f;
                fArray[n11] = f7;
                fArray[n11 + 1] = f6;
                fArray[n11 + 3] = -fArray[n11 + 3];
                n12 = n2 + (n14 += n6);
                n11 = n2 + (n13 += n6);
                fArray[n12 - 1] = -fArray[n12 - 1];
                f7 = fArray[n12];
                f6 = -fArray[n12 + 1];
                f5 = fArray[n11];
                f = -fArray[n11 + 1];
                fArray[n12] = f5;
                fArray[n12 + 1] = f;
                fArray[n11] = f7;
                fArray[n11 + 1] = f6;
                fArray[n11 + 3] = -fArray[n11 + 3];
            }
        }
    }

    private void bitrv216(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 14];
        float f12 = fArray[n + 15];
        float f13 = fArray[n + 16];
        float f14 = fArray[n + 17];
        float f15 = fArray[n + 20];
        float f16 = fArray[n + 21];
        float f17 = fArray[n + 22];
        float f18 = fArray[n + 23];
        float f19 = fArray[n + 24];
        float f20 = fArray[n + 25];
        float f21 = fArray[n + 26];
        float f22 = fArray[n + 27];
        float f23 = fArray[n + 28];
        float f24 = fArray[n + 29];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f7;
        fArray[n + 5] = f8;
        fArray[n + 6] = f19;
        fArray[n + 7] = f20;
        fArray[n + 8] = f3;
        fArray[n + 9] = f4;
        fArray[n + 10] = f15;
        fArray[n + 11] = f16;
        fArray[n + 14] = f23;
        fArray[n + 15] = f24;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 20] = f9;
        fArray[n + 21] = f10;
        fArray[n + 22] = f21;
        fArray[n + 23] = f22;
        fArray[n + 24] = f5;
        fArray[n + 25] = f6;
        fArray[n + 26] = f17;
        fArray[n + 27] = f18;
        fArray[n + 28] = f11;
        fArray[n + 29] = f12;
    }

    private void bitrv216neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        float f15 = fArray[n + 16];
        float f16 = fArray[n + 17];
        float f17 = fArray[n + 18];
        float f18 = fArray[n + 19];
        float f19 = fArray[n + 20];
        float f20 = fArray[n + 21];
        float f21 = fArray[n + 22];
        float f22 = fArray[n + 23];
        float f23 = fArray[n + 24];
        float f24 = fArray[n + 25];
        float f25 = fArray[n + 26];
        float f26 = fArray[n + 27];
        float f27 = fArray[n + 28];
        float f28 = fArray[n + 29];
        float f29 = fArray[n + 30];
        float f30 = fArray[n + 31];
        fArray[n + 2] = f29;
        fArray[n + 3] = f30;
        fArray[n + 4] = f13;
        fArray[n + 5] = f14;
        fArray[n + 6] = f21;
        fArray[n + 7] = f22;
        fArray[n + 8] = f5;
        fArray[n + 9] = f6;
        fArray[n + 10] = f25;
        fArray[n + 11] = f26;
        fArray[n + 12] = f9;
        fArray[n + 13] = f10;
        fArray[n + 14] = f17;
        fArray[n + 15] = f18;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 18] = f27;
        fArray[n + 19] = f28;
        fArray[n + 20] = f11;
        fArray[n + 21] = f12;
        fArray[n + 22] = f19;
        fArray[n + 23] = f20;
        fArray[n + 24] = f3;
        fArray[n + 25] = f4;
        fArray[n + 26] = f23;
        fArray[n + 27] = f24;
        fArray[n + 28] = f7;
        fArray[n + 29] = f8;
        fArray[n + 30] = f15;
        fArray[n + 31] = f16;
    }

    private void bitrv208(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 6];
        float f4 = fArray[n + 7];
        float f5 = fArray[n + 8];
        float f6 = fArray[n + 9];
        float f7 = fArray[n + 12];
        float f8 = fArray[n + 13];
        fArray[n + 2] = f5;
        fArray[n + 3] = f6;
        fArray[n + 6] = f7;
        fArray[n + 7] = f8;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
    }

    private void bitrv208neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f5;
        fArray[n + 5] = f6;
        fArray[n + 6] = f9;
        fArray[n + 7] = f10;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 10] = f11;
        fArray[n + 11] = f12;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
        fArray[n + 14] = f7;
        fArray[n + 15] = f8;
    }

    private void cftf1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = fArray[n2 + 1] + fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = fArray[n2 + 1] - fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        fArray[n12] = f7 - f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 + f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = fArray[n16 + 1] + fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n12];
            f8 = fArray[n16 + 1] - fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = fArray[n16 + 3] + fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = fArray[n16 + 3] - fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 + f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = fArray[n4 + 1] + fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = fArray[n4 + 1] - fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = fArray[n4 - 1] + fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = fArray[n4 - 1] - fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 + f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n2 + n10 - 2] = f19 * f5 + f18 * f6;
            fArray[n2 + n10 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = fArray[n4 - 1] + fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = fArray[n4 - 1] - fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 + f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = fArray[n4 + 1] + fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = fArray[n4 + 1] - fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = fArray[n4 + 3] + fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = fArray[n4 + 3] - fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 + f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    private void cftb1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = -fArray[n2 + 1] - fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = -fArray[n2 + 1] + fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        fArray[n12] = f7 + f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 - f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = -fArray[n16 + 1] - fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n2 + n9];
            f8 = -fArray[n16 + 1] + fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = -fArray[n16 + 3] - fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = -fArray[n16 + 3] + fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 - f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = -fArray[n4 + 1] - fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = -fArray[n4 + 1] + fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = -fArray[n4 - 1] - fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = -fArray[n4 - 1] + fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 - f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 - 2] = f19 * f5 + f18 * f6;
            fArray[n13 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = -fArray[n4 - 1] - fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = -fArray[n4 - 1] + fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 - f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = -fArray[n4 + 1] - fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = -fArray[n4 + 1] + fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = -fArray[n4 + 3] - fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = -fArray[n4 + 3] + fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 - f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    private void cftrec4_th(final int n, final float[] fArray, int n2, final int n3, final float[] fArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if (n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        FloatDCT_1D.this.cftmdl1(n2 >>= 2, fArray, n6 - n2, fArray2, n3 - (n2 >> 1));
                    }
                    FloatDCT_1D.this.cftleaf(n2, 1, fArray, n6 - n2, n3, fArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = FloatDCT_1D.this.cfttree(n2, i, ++n32, fArray, n9, n3, fArray2);
                        FloatDCT_1D.this.cftleaf(n2, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        FloatDCT_1D.this.cftmdl2(n32 >>= 2, fArray, n6 - n32, fArray2, n3 - n32);
                    }
                    FloatDCT_1D.this.cftleaf(n32, 0, fArray, n6 - n32, n3, fArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = FloatDCT_1D.this.cfttree(n32, i, ++n2, fArray, n9, n3, fArray2);
                        FloatDCT_1D.this.cftleaf(n32, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cftrec4(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        int n4 = n2 + n;
        int n5 = n;
        while (n5 > 512) {
            this.cftmdl1(n5 >>= 2, fArray, n4 - n5, fArray2, n3 - (n5 >> 1));
        }
        this.cftleaf(n5, 1, fArray, n4 - n5, n3, fArray2);
        int n6 = 0;
        int n7 = n2 - n5;
        for (int i = n - n5; i > 0; i -= n5) {
            int n8 = this.cfttree(n5, i, ++n6, fArray, n2, n3, fArray2);
            this.cftleaf(n5, n8, fArray, n7 + i, n3, fArray2);
        }
    }

    private int cfttree(int n, int n2, int n3, float[] fArray, int n4, int n5, float[] fArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                this.cftmdl1(n, fArray, n7 + n2, fArray2, n5 - (n >> 1));
            } else {
                this.cftmdl2(n, fArray, n7 + n2, fArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    this.cftmdl1(n8, fArray, n10 - n8, fArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    this.cftmdl2(n8, fArray, n10 - n8, fArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    private void cftleaf(int n, int n2, float[] fArray, int n3, int n4, float[] fArray2) {
        if (n == 512) {
            this.cftmdl1(128, fArray, n3, fArray2, n4 - 64);
            this.cftf161(fArray, n3, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 32, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 64, fArray2, n4 - 8);
            this.cftf161(fArray, n3 + 96, fArray2, n4 - 8);
            this.cftmdl2(128, fArray, n3 + 128, fArray2, n4 - 128);
            this.cftf161(fArray, n3 + 128, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 160, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 192, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 224, fArray2, n4 - 32);
            this.cftmdl1(128, fArray, n3 + 256, fArray2, n4 - 64);
            this.cftf161(fArray, n3 + 256, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 288, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 320, fArray2, n4 - 8);
            this.cftf161(fArray, n3 + 352, fArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(128, fArray, n3 + 384, fArray2, n4 - 64);
                this.cftf161(fArray, n3 + 480, fArray2, n4 - 8);
            } else {
                this.cftmdl2(128, fArray, n3 + 384, fArray2, n4 - 128);
                this.cftf162(fArray, n3 + 480, fArray2, n4 - 32);
            }
            this.cftf161(fArray, n3 + 384, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 416, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 448, fArray2, n4 - 8);
        } else {
            this.cftmdl1(64, fArray, n3, fArray2, n4 - 32);
            this.cftf081(fArray, n3, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 16, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 32, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 48, fArray2, n4 - 8);
            this.cftmdl2(64, fArray, n3 + 64, fArray2, n4 - 64);
            this.cftf081(fArray, n3 + 64, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 80, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 96, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 112, fArray2, n4 - 8);
            this.cftmdl1(64, fArray, n3 + 128, fArray2, n4 - 32);
            this.cftf081(fArray, n3 + 128, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 144, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 160, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 176, fArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(64, fArray, n3 + 192, fArray2, n4 - 32);
                this.cftf081(fArray, n3 + 240, fArray2, n4 - 8);
            } else {
                this.cftmdl2(64, fArray, n3 + 192, fArray2, n4 - 64);
                this.cftf082(fArray, n3 + 240, fArray2, n4 - 8);
            }
            this.cftf081(fArray, n3 + 192, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 208, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 224, fArray2, n4 - 8);
        }
    }

    private void cftmdl1(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f = fArray[n2] + fArray[n12];
        float f2 = fArray[n2 + 1] + fArray[n12 + 1];
        float f3 = fArray[n2] - fArray[n12];
        float f4 = fArray[n2 + 1] - fArray[n12 + 1];
        float f5 = fArray[n11] + fArray[n13];
        float f6 = fArray[n11 + 1] + fArray[n13 + 1];
        float f7 = fArray[n11] - fArray[n13];
        float f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f + f5;
        fArray[n2 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        fArray[n12] = f3 - f8;
        fArray[n12 + 1] = f4 + f7;
        fArray[n13] = f3 + f8;
        fArray[n13 + 1] = f4 - f7;
        float f9 = fArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            float f10 = fArray2[n15];
            float f11 = fArray2[n15 + 1];
            float f12 = fArray2[n15 + 2];
            float f13 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f = fArray[n16] + fArray[n12];
            f2 = fArray[n16 + 1] + fArray[n12 + 1];
            f3 = fArray[n16] - fArray[n12];
            f4 = fArray[n16 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n16] = f + f5;
            fArray[n16 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f10 * f - f11 * f2;
            fArray[n12 + 1] = f10 * f2 + f11 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f12 * f + f13 * f2;
            fArray[n13 + 1] = f12 * f2 - f13 * f;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f = fArray[n4] + fArray[n12];
            f2 = fArray[n4 + 1] + fArray[n12 + 1];
            f3 = fArray[n4] - fArray[n12];
            f4 = fArray[n4 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n4] = f + f5;
            fArray[n4 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f11 * f - f10 * f2;
            fArray[n12 + 1] = f11 * f2 + f10 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f13 * f + f12 * f2;
            fArray[n13 + 1] = f13 * f2 - f12 * f;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f = fArray[n4] + fArray[n12];
        f2 = fArray[n4 + 1] + fArray[n12 + 1];
        f3 = fArray[n4] - fArray[n12];
        f4 = fArray[n4 + 1] - fArray[n12 + 1];
        f5 = fArray[n11] + fArray[n13];
        f6 = fArray[n11 + 1] + fArray[n13 + 1];
        f7 = fArray[n11] - fArray[n13];
        f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f + f5;
        fArray[n4 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        f = f3 - f8;
        f2 = f4 + f7;
        fArray[n12] = f9 * (f - f2);
        fArray[n12 + 1] = f9 * (f2 + f);
        f = f3 + f8;
        f2 = f4 - f7;
        fArray[n13] = -f9 * (f + f2);
        fArray[n13 + 1] = -f9 * (f2 - f);
    }

    private void cftmdl2(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        float f5 = fArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f6 = fArray[n2] - fArray[n12 + 1];
        float f7 = fArray[n2 + 1] + fArray[n12];
        float f8 = fArray[n2] + fArray[n12 + 1];
        float f9 = fArray[n2 + 1] - fArray[n12];
        float f10 = fArray[n11] - fArray[n13 + 1];
        float f11 = fArray[n11 + 1] + fArray[n13];
        float f12 = fArray[n11] + fArray[n13 + 1];
        float f13 = fArray[n11 + 1] - fArray[n13];
        float f14 = f5 * (f10 - f11);
        float f15 = f5 * (f11 + f10);
        fArray[n2] = f6 + f14;
        fArray[n2 + 1] = f7 + f15;
        fArray[n11] = f6 - f14;
        fArray[n11 + 1] = f7 - f15;
        f14 = f5 * (f12 - f13);
        f15 = f5 * (f13 + f12);
        fArray[n12] = f8 - f15;
        fArray[n12 + 1] = f9 + f14;
        fArray[n13] = f8 + f15;
        fArray[n13 + 1] = f9 - f14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            f4 = fArray2[n16];
            f3 = fArray2[n16 + 1];
            float f16 = fArray2[n16 + 2];
            float f17 = fArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            float f18 = fArray2[n17];
            float f19 = fArray2[n17 + 1];
            float f20 = fArray2[n17 + 2];
            float f21 = fArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            f6 = fArray[n18] - fArray[n12 + 1];
            f7 = fArray[n18 + 1] + fArray[n12];
            f8 = fArray[n18] + fArray[n12 + 1];
            f9 = fArray[n18 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f4 * f6 - f3 * f7;
            f15 = f4 * f7 + f3 * f6;
            f2 = f19 * f10 - f18 * f11;
            f = f19 * f11 + f18 * f10;
            fArray[n18] = f14 + f2;
            fArray[n18 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f16 * f8 + f17 * f9;
            f15 = f16 * f9 - f17 * f8;
            f2 = f21 * f12 + f20 * f13;
            f = f21 * f13 - f20 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f6 = fArray[n4] - fArray[n12 + 1];
            f7 = fArray[n4 + 1] + fArray[n12];
            f8 = fArray[n4] + fArray[n12 + 1];
            f9 = fArray[n4 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f18 * f6 - f19 * f7;
            f15 = f18 * f7 + f19 * f6;
            f2 = f3 * f10 - f4 * f11;
            f = f3 * f11 + f4 * f10;
            fArray[n4] = f14 + f2;
            fArray[n4 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f20 * f8 + f21 * f9;
            f15 = f20 * f9 - f21 * f8;
            f2 = f17 * f12 + f16 * f13;
            f = f17 * f13 - f16 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
        }
        f4 = fArray2[n3 + n7];
        f3 = fArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f6 = fArray[n4] - fArray[n12 + 1];
        f7 = fArray[n4 + 1] + fArray[n12];
        f8 = fArray[n4] + fArray[n12 + 1];
        f9 = fArray[n4 + 1] - fArray[n12];
        f10 = fArray[n11] - fArray[n13 + 1];
        f11 = fArray[n11 + 1] + fArray[n13];
        f12 = fArray[n11] + fArray[n13 + 1];
        f13 = fArray[n11 + 1] - fArray[n13];
        f14 = f4 * f6 - f3 * f7;
        f15 = f4 * f7 + f3 * f6;
        f2 = f3 * f10 - f4 * f11;
        f = f3 * f11 + f4 * f10;
        fArray[n4] = f14 + f2;
        fArray[n4 + 1] = f15 + f;
        fArray[n11] = f14 - f2;
        fArray[n11 + 1] = f15 - f;
        f14 = f3 * f8 - f4 * f9;
        f15 = f3 * f9 + f4 * f8;
        f2 = f4 * f12 - f3 * f13;
        f = f4 * f13 + f3 * f12;
        fArray[n12] = f14 - f2;
        fArray[n12 + 1] = f15 - f;
        fArray[n13] = f14 + f2;
        fArray[n13 + 1] = f15 + f;
    }

    private void cftfx41(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        if (n == 128) {
            this.cftf161(fArray, n2, fArray2, n3 - 8);
            this.cftf162(fArray, n2 + 32, fArray2, n3 - 32);
            this.cftf161(fArray, n2 + 64, fArray2, n3 - 8);
            this.cftf161(fArray, n2 + 96, fArray2, n3 - 8);
        } else {
            this.cftf081(fArray, n2, fArray2, n3 - 8);
            this.cftf082(fArray, n2 + 16, fArray2, n3 - 8);
            this.cftf081(fArray, n2 + 32, fArray2, n3 - 8);
            this.cftf081(fArray, n2 + 48, fArray2, n3 - 8);
        }
    }

    private void cftf161(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] + fArray[n + 16];
        float f5 = fArray[n + 1] + fArray[n + 17];
        float f6 = fArray[n] - fArray[n + 16];
        float f7 = fArray[n + 1] - fArray[n + 17];
        float f8 = fArray[n + 8] + fArray[n + 24];
        float f9 = fArray[n + 9] + fArray[n + 25];
        float f10 = fArray[n + 8] - fArray[n + 24];
        float f11 = fArray[n + 9] - fArray[n + 25];
        float f12 = f4 + f8;
        float f13 = f5 + f9;
        float f14 = f4 - f8;
        float f15 = f5 - f9;
        float f16 = f6 - f11;
        float f17 = f7 + f10;
        float f18 = f6 + f11;
        float f19 = f7 - f10;
        f4 = fArray[n + 2] + fArray[n + 18];
        f5 = fArray[n + 3] + fArray[n + 19];
        f6 = fArray[n + 2] - fArray[n + 18];
        f7 = fArray[n + 3] - fArray[n + 19];
        f8 = fArray[n + 10] + fArray[n + 26];
        f9 = fArray[n + 11] + fArray[n + 27];
        f10 = fArray[n + 10] - fArray[n + 26];
        f11 = fArray[n + 11] - fArray[n + 27];
        float f20 = f4 + f8;
        float f21 = f5 + f9;
        float f22 = f4 - f8;
        float f23 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f24 = f2 * f4 - f3 * f5;
        float f25 = f2 * f5 + f3 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f26 = f3 * f4 - f2 * f5;
        float f27 = f3 * f5 + f2 * f4;
        f4 = fArray[n + 4] + fArray[n + 20];
        f5 = fArray[n + 5] + fArray[n + 21];
        f6 = fArray[n + 4] - fArray[n + 20];
        f7 = fArray[n + 5] - fArray[n + 21];
        f8 = fArray[n + 12] + fArray[n + 28];
        f9 = fArray[n + 13] + fArray[n + 29];
        f10 = fArray[n + 12] - fArray[n + 28];
        f11 = fArray[n + 13] - fArray[n + 29];
        float f28 = f4 + f8;
        float f29 = f5 + f9;
        float f30 = f4 - f8;
        float f31 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f32 = f * (f4 - f5);
        float f33 = f * (f5 + f4);
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f34 = f * (f4 + f5);
        float f35 = f * (f5 - f4);
        f4 = fArray[n + 6] + fArray[n + 22];
        f5 = fArray[n + 7] + fArray[n + 23];
        f6 = fArray[n + 6] - fArray[n + 22];
        f7 = fArray[n + 7] - fArray[n + 23];
        f8 = fArray[n + 14] + fArray[n + 30];
        f9 = fArray[n + 15] + fArray[n + 31];
        f10 = fArray[n + 14] - fArray[n + 30];
        f11 = fArray[n + 15] - fArray[n + 31];
        float f36 = f4 + f8;
        float f37 = f5 + f9;
        float f38 = f4 - f8;
        float f39 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f40 = f3 * f4 - f2 * f5;
        float f41 = f3 * f5 + f2 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f42 = f2 * f4 - f3 * f5;
        float f43 = f2 * f5 + f3 * f4;
        f4 = f18 - f34;
        f5 = f19 - f35;
        f6 = f18 + f34;
        f7 = f19 + f35;
        f8 = f26 - f42;
        f9 = f27 - f43;
        f10 = f26 + f42;
        f11 = f27 + f43;
        fArray[n + 24] = f4 + f8;
        fArray[n + 25] = f5 + f9;
        fArray[n + 26] = f4 - f8;
        fArray[n + 27] = f5 - f9;
        fArray[n + 28] = f6 - f11;
        fArray[n + 29] = f7 + f10;
        fArray[n + 30] = f6 + f11;
        fArray[n + 31] = f7 - f10;
        f4 = f16 + f32;
        f5 = f17 + f33;
        f6 = f16 - f32;
        f7 = f17 - f33;
        f8 = f24 + f40;
        f9 = f25 + f41;
        f10 = f24 - f40;
        f11 = f25 - f41;
        fArray[n + 16] = f4 + f8;
        fArray[n + 17] = f5 + f9;
        fArray[n + 18] = f4 - f8;
        fArray[n + 19] = f5 - f9;
        fArray[n + 20] = f6 - f11;
        fArray[n + 21] = f7 + f10;
        fArray[n + 22] = f6 + f11;
        fArray[n + 23] = f7 - f10;
        f4 = f22 - f39;
        f5 = f23 + f38;
        f8 = f * (f4 - f5);
        f9 = f * (f5 + f4);
        f4 = f22 + f39;
        f5 = f23 - f38;
        f10 = f * (f4 - f5);
        f11 = f * (f5 + f4);
        f4 = f14 - f31;
        f5 = f15 + f30;
        f6 = f14 + f31;
        f7 = f15 - f30;
        fArray[n + 8] = f4 + f8;
        fArray[n + 9] = f5 + f9;
        fArray[n + 10] = f4 - f8;
        fArray[n + 11] = f5 - f9;
        fArray[n + 12] = f6 - f11;
        fArray[n + 13] = f7 + f10;
        fArray[n + 14] = f6 + f11;
        fArray[n + 15] = f7 - f10;
        f4 = f12 + f28;
        f5 = f13 + f29;
        f6 = f12 - f28;
        f7 = f13 - f29;
        f8 = f20 + f36;
        f9 = f21 + f37;
        f10 = f20 - f36;
        f11 = f21 - f37;
        fArray[n] = f4 + f8;
        fArray[n + 1] = f5 + f9;
        fArray[n + 2] = f4 - f8;
        fArray[n + 3] = f5 - f9;
        fArray[n + 4] = f6 - f11;
        fArray[n + 5] = f7 + f10;
        fArray[n + 6] = f6 + f11;
        fArray[n + 7] = f7 - f10;
    }

    private void cftf162(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 4];
        float f3 = fArray2[n2 + 5];
        float f4 = fArray2[n2 + 6];
        float f5 = -fArray2[n2 + 7];
        float f6 = fArray2[n2 + 8];
        float f7 = fArray2[n2 + 9];
        float f8 = fArray[n] - fArray[n + 17];
        float f9 = fArray[n + 1] + fArray[n + 16];
        float f10 = fArray[n + 8] - fArray[n + 25];
        float f11 = fArray[n + 9] + fArray[n + 24];
        float f12 = f * (f10 - f11);
        float f13 = f * (f11 + f10);
        float f14 = f8 + f12;
        float f15 = f9 + f13;
        float f16 = f8 - f12;
        float f17 = f9 - f13;
        f8 = fArray[n] + fArray[n + 17];
        f9 = fArray[n + 1] - fArray[n + 16];
        f10 = fArray[n + 8] + fArray[n + 25];
        f11 = fArray[n + 9] - fArray[n + 24];
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        float f18 = f8 - f13;
        float f19 = f9 + f12;
        float f20 = f8 + f13;
        float f21 = f9 - f12;
        f10 = fArray[n + 2] - fArray[n + 19];
        f11 = fArray[n + 3] + fArray[n + 18];
        f8 = f2 * f10 - f3 * f11;
        f9 = f2 * f11 + f3 * f10;
        f10 = fArray[n + 10] - fArray[n + 27];
        f11 = fArray[n + 11] + fArray[n + 26];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f22 = f8 + f12;
        float f23 = f9 + f13;
        float f24 = f8 - f12;
        float f25 = f9 - f13;
        f10 = fArray[n + 2] + fArray[n + 19];
        f11 = fArray[n + 3] - fArray[n + 18];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 10] + fArray[n + 27];
        f11 = fArray[n + 11] - fArray[n + 26];
        f12 = f2 * f10 + f3 * f11;
        f13 = f2 * f11 - f3 * f10;
        float f26 = f8 - f12;
        float f27 = f9 - f13;
        float f28 = f8 + f12;
        float f29 = f9 + f13;
        f10 = fArray[n + 4] - fArray[n + 21];
        f11 = fArray[n + 5] + fArray[n + 20];
        f8 = f6 * f10 - f7 * f11;
        f9 = f6 * f11 + f7 * f10;
        f10 = fArray[n + 12] - fArray[n + 29];
        f11 = fArray[n + 13] + fArray[n + 28];
        f12 = f7 * f10 - f6 * f11;
        f13 = f7 * f11 + f6 * f10;
        float f30 = f8 + f12;
        float f31 = f9 + f13;
        float f32 = f8 - f12;
        float f33 = f9 - f13;
        f10 = fArray[n + 4] + fArray[n + 21];
        f11 = fArray[n + 5] - fArray[n + 20];
        f8 = f7 * f10 - f6 * f11;
        f9 = f7 * f11 + f6 * f10;
        f10 = fArray[n + 12] + fArray[n + 29];
        f11 = fArray[n + 13] - fArray[n + 28];
        f12 = f6 * f10 - f7 * f11;
        f13 = f6 * f11 + f7 * f10;
        float f34 = f8 - f12;
        float f35 = f9 - f13;
        float f36 = f8 + f12;
        float f37 = f9 + f13;
        f10 = fArray[n + 6] - fArray[n + 23];
        f11 = fArray[n + 7] + fArray[n + 22];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 14] - fArray[n + 31];
        f11 = fArray[n + 15] + fArray[n + 30];
        f12 = f3 * f10 - f2 * f11;
        f13 = f3 * f11 + f2 * f10;
        float f38 = f8 + f12;
        float f39 = f9 + f13;
        float f40 = f8 - f12;
        float f41 = f9 - f13;
        f10 = fArray[n + 6] + fArray[n + 23];
        f11 = fArray[n + 7] - fArray[n + 22];
        f8 = f3 * f10 + f2 * f11;
        f9 = f3 * f11 - f2 * f10;
        f10 = fArray[n + 14] + fArray[n + 31];
        f11 = fArray[n + 15] - fArray[n + 30];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f42 = f8 + f12;
        float f43 = f9 + f13;
        float f44 = f8 - f12;
        float f45 = f9 - f13;
        f8 = f14 + f30;
        f9 = f15 + f31;
        f12 = f22 + f38;
        f13 = f23 + f39;
        fArray[n] = f8 + f12;
        fArray[n + 1] = f9 + f13;
        fArray[n + 2] = f8 - f12;
        fArray[n + 3] = f9 - f13;
        f8 = f14 - f30;
        f9 = f15 - f31;
        f12 = f22 - f38;
        f13 = f23 - f39;
        fArray[n + 4] = f8 - f13;
        fArray[n + 5] = f9 + f12;
        fArray[n + 6] = f8 + f13;
        fArray[n + 7] = f9 - f12;
        f8 = f16 - f33;
        f9 = f17 + f32;
        f10 = f24 - f41;
        f11 = f25 + f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 8] = f8 + f12;
        fArray[n + 9] = f9 + f13;
        fArray[n + 10] = f8 - f12;
        fArray[n + 11] = f9 - f13;
        f8 = f16 + f33;
        f9 = f17 - f32;
        f10 = f24 + f41;
        f11 = f25 - f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 12] = f8 - f13;
        fArray[n + 13] = f9 + f12;
        fArray[n + 14] = f8 + f13;
        fArray[n + 15] = f9 - f12;
        f8 = f18 + f34;
        f9 = f19 + f35;
        f12 = f26 - f42;
        f13 = f27 - f43;
        fArray[n + 16] = f8 + f12;
        fArray[n + 17] = f9 + f13;
        fArray[n + 18] = f8 - f12;
        fArray[n + 19] = f9 - f13;
        f8 = f18 - f34;
        f9 = f19 - f35;
        f12 = f26 + f42;
        f13 = f27 + f43;
        fArray[n + 20] = f8 - f13;
        fArray[n + 21] = f9 + f12;
        fArray[n + 22] = f8 + f13;
        fArray[n + 23] = f9 - f12;
        f8 = f20 - f37;
        f9 = f21 + f36;
        f10 = f28 + f45;
        f11 = f29 - f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 24] = f8 + f12;
        fArray[n + 25] = f9 + f13;
        fArray[n + 26] = f8 - f12;
        fArray[n + 27] = f9 - f13;
        f8 = f20 + f37;
        f9 = f21 - f36;
        f10 = f28 - f45;
        f11 = f29 + f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 28] = f8 - f13;
        fArray[n + 29] = f9 + f12;
        fArray[n + 30] = f8 + f13;
        fArray[n + 31] = f9 - f12;
    }

    private void cftf081(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray[n] + fArray[n + 8];
        float f3 = fArray[n + 1] + fArray[n + 9];
        float f4 = fArray[n] - fArray[n + 8];
        float f5 = fArray[n + 1] - fArray[n + 9];
        float f6 = fArray[n + 4] + fArray[n + 12];
        float f7 = fArray[n + 5] + fArray[n + 13];
        float f8 = fArray[n + 4] - fArray[n + 12];
        float f9 = fArray[n + 5] - fArray[n + 13];
        float f10 = f2 + f6;
        float f11 = f3 + f7;
        float f12 = f2 - f6;
        float f13 = f3 - f7;
        float f14 = f4 - f9;
        float f15 = f5 + f8;
        float f16 = f4 + f9;
        float f17 = f5 - f8;
        f2 = fArray[n + 2] + fArray[n + 10];
        f3 = fArray[n + 3] + fArray[n + 11];
        f4 = fArray[n + 2] - fArray[n + 10];
        f5 = fArray[n + 3] - fArray[n + 11];
        f6 = fArray[n + 6] + fArray[n + 14];
        f7 = fArray[n + 7] + fArray[n + 15];
        f8 = fArray[n + 6] - fArray[n + 14];
        f9 = fArray[n + 7] - fArray[n + 15];
        float f18 = f2 + f6;
        float f19 = f3 + f7;
        float f20 = f2 - f6;
        float f21 = f3 - f7;
        f2 = f4 - f9;
        f3 = f5 + f8;
        f6 = f4 + f9;
        f7 = f5 - f8;
        float f22 = f * (f2 - f3);
        float f23 = f * (f2 + f3);
        float f24 = f * (f6 - f7);
        float f25 = f * (f6 + f7);
        fArray[n + 8] = f14 + f22;
        fArray[n + 9] = f15 + f23;
        fArray[n + 10] = f14 - f22;
        fArray[n + 11] = f15 - f23;
        fArray[n + 12] = f16 - f25;
        fArray[n + 13] = f17 + f24;
        fArray[n + 14] = f16 + f25;
        fArray[n + 15] = f17 - f24;
        fArray[n] = f10 + f18;
        fArray[n + 1] = f11 + f19;
        fArray[n + 2] = f10 - f18;
        fArray[n + 3] = f11 - f19;
        fArray[n + 4] = f12 - f21;
        fArray[n + 5] = f13 + f20;
        fArray[n + 6] = f12 + f21;
        fArray[n + 7] = f13 - f20;
    }

    private void cftf082(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] - fArray[n + 9];
        float f5 = fArray[n + 1] + fArray[n + 8];
        float f6 = fArray[n] + fArray[n + 9];
        float f7 = fArray[n + 1] - fArray[n + 8];
        float f8 = fArray[n + 4] - fArray[n + 13];
        float f9 = fArray[n + 5] + fArray[n + 12];
        float f10 = f * (f8 - f9);
        float f11 = f * (f9 + f8);
        f8 = fArray[n + 4] + fArray[n + 13];
        f9 = fArray[n + 5] - fArray[n + 12];
        float f12 = f * (f8 - f9);
        float f13 = f * (f9 + f8);
        f8 = fArray[n + 2] - fArray[n + 11];
        f9 = fArray[n + 3] + fArray[n + 10];
        float f14 = f2 * f8 - f3 * f9;
        float f15 = f2 * f9 + f3 * f8;
        f8 = fArray[n + 2] + fArray[n + 11];
        f9 = fArray[n + 3] - fArray[n + 10];
        float f16 = f3 * f8 - f2 * f9;
        float f17 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] - fArray[n + 15];
        f9 = fArray[n + 7] + fArray[n + 14];
        float f18 = f3 * f8 - f2 * f9;
        float f19 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] + fArray[n + 15];
        f9 = fArray[n + 7] - fArray[n + 14];
        float f20 = f2 * f8 - f3 * f9;
        float f21 = f2 * f9 + f3 * f8;
        f8 = f4 + f10;
        f9 = f5 + f11;
        float f22 = f14 + f18;
        float f23 = f15 + f19;
        fArray[n] = f8 + f22;
        fArray[n + 1] = f9 + f23;
        fArray[n + 2] = f8 - f22;
        fArray[n + 3] = f9 - f23;
        f8 = f4 - f10;
        f9 = f5 - f11;
        f22 = f14 - f18;
        f23 = f15 - f19;
        fArray[n + 4] = f8 - f23;
        fArray[n + 5] = f9 + f22;
        fArray[n + 6] = f8 + f23;
        fArray[n + 7] = f9 - f22;
        f8 = f6 - f13;
        f9 = f7 + f12;
        f22 = f16 - f20;
        f23 = f17 - f21;
        fArray[n + 8] = f8 + f22;
        fArray[n + 9] = f9 + f23;
        fArray[n + 10] = f8 - f22;
        fArray[n + 11] = f9 - f23;
        f8 = f6 + f13;
        f9 = f7 - f12;
        f22 = f16 + f20;
        f23 = f17 + f21;
        fArray[n + 12] = f8 - f23;
        fArray[n + 13] = f9 + f22;
        fArray[n + 14] = f8 + f23;
        fArray[n + 15] = f9 - f22;
    }

    private void cftf040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 - f8;
        fArray[n + 3] = f4 + f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 + f8;
        fArray[n + 7] = f4 - f7;
    }

    private void cftb040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 + f8;
        fArray[n + 3] = f4 - f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 - f8;
        fArray[n + 7] = f4 + f7;
    }

    private void cftx020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = fArray[n + 1] - fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    private void rftfsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = (float)(0.5 - (double)fArray2[n4 + n3 - (n7 += n6)]);
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            int n12 = n9 + 1;
            fArray[n12] = fArray[n12] - f6;
            int n13 = n10;
            fArray[n13] = fArray[n13] + f5;
            int n14 = n10 + 1;
            fArray[n14] = fArray[n14] - f6;
        }
    }

    private void rftbsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = (float)(0.5 - (double)fArray2[n4 + n3 - (n7 += n6)]);
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 + f2 * f4;
            float f6 = f * f4 - f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            int n12 = n9 + 1;
            fArray[n12] = fArray[n12] - f6;
            int n13 = n10;
            fArray[n13] = fArray[n13] + f5;
            int n14 = n10 + 1;
            fArray[n14] = fArray[n14] - f6;
        }
    }

    private void dctsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = n3 / n;
        int n7 = 0;
        for (int i = 1; i < n5; ++i) {
            int n8 = n - i;
            int n9 = n4 + (n7 += n6);
            int n10 = n2 + i;
            int n11 = n2 + n8;
            float f = fArray2[n9] - fArray2[n4 + n3 - n7];
            float f2 = fArray2[n9] + fArray2[n4 + n3 - n7];
            float f3 = f2 * fArray[n10] - f * fArray[n11];
            fArray[n10] = f * fArray[n10] + f2 * fArray[n11];
            fArray[n11] = f3;
        }
        int n12 = n2 + n5;
        fArray[n12] = fArray[n12] * fArray2[n4];
    }

    private void scale(final float f, final float[] fArray, int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n3 = this.n / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n4 = n + i * n3;
                final int n5 = i == n2 - 1 ? n + this.n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (n < n5) {
                            int n2 = n++;
                            fArray[n2] = fArray[n2] * f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            int n7 = n + this.n;
            int n8 = n6;
            while (n8 < n7) {
                int n9 = n8++;
                fArray[n9] = fArray[n9] * f;
            }
        }
    }
}

