/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import ed.javatools.BufferedRandomAccessFile;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.FixedStepContigIndex;
import edu.unc.genomics.io.VariableStepContigIndex;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

abstract class ContigIndex
extends Interval
implements Serializable {
    private static final long serialVersionUID = 7665673936467048945L;
    private int span;
    private long startLine;
    private long stopLine;
    private Map<Integer, Long> index = new HashMap<Integer, Long>();

    protected ContigIndex(String chr, int start, int stop, int span) {
        super(chr, start, stop);
        this.span = span;
    }

    public static ContigIndex parseHeader(String headerLine) throws WigFileFormatException {
        if (headerLine.startsWith(Contig.Type.FIXEDSTEP.getId())) {
            return FixedStepContigIndex.parseHeader(headerLine);
        }
        if (headerLine.startsWith(Contig.Type.VARIABLESTEP.getId())) {
            return VariableStepContigIndex.parseHeader(headerLine);
        }
        throw new WigFileFormatException("Unknown Contig type: " + headerLine);
    }

    public abstract void fill(BufferedRandomAccessFile var1, Interval var2, float[] var3) throws WigFileException, IOException;

    public abstract void fillStats(BufferedRandomAccessFile var1, Interval var2, SummaryStatistics var3) throws WigFileException, IOException;

    public abstract boolean isFixedStep();

    public abstract boolean isVariableStep();

    @Override
    public abstract String toOutput();

    public void storeIndex(int bp, long pos) {
        this.index.put(bp, pos);
    }

    public long getIndex(int bp) {
        return this.index.get(bp);
    }

    public int getUpstreamIndexedBP(int bp) {
        int closestBP = -1;
        for (int indexBP : this.index.keySet()) {
            if (indexBP <= closestBP || indexBP > bp) continue;
            closestBP = indexBP;
        }
        return closestBP;
    }

    public int getSpan() {
        return this.span;
    }

    public long getStartLine() {
        return this.startLine;
    }

    public void setStartLine(long startLine) {
        this.startLine = startLine;
    }

    public long getStopLine() {
        return this.stopLine;
    }

    public void setStopLine(long stopLine) {
        this.stopLine = stopLine;
    }
}

