/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;

public class ZoomDataRecord {
    private static Logger log = Logger.getLogger(ZoomDataRecord.class);
    public static final int RECORD_SIZE = 32;
    private int zoomLevel;
    private int recordNumber;
    private String chromName;
    private int chromId;
    private int chromStart;
    private int chromEnd;
    private int basesCovered;
    private float minVal;
    private float maxVal;
    private float sumData;
    private float sumSquares;

    public ZoomDataRecord(int zoomLevel, int recordNumber, String chromName, int chromId, int chromStart, int chromEnd, int validCount, float minVal, float maxVal, float sumData, float sumSquares) {
        this.zoomLevel = zoomLevel;
        this.recordNumber = recordNumber;
        this.chromName = chromName;
        this.chromId = chromId;
        this.chromStart = chromStart;
        this.chromEnd = chromEnd;
        this.basesCovered = validCount;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.sumData = sumData;
        this.sumSquares = sumSquares;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getChromName() {
        return this.chromName;
    }

    public int getChromId() {
        return this.chromId;
    }

    public int getChromStart() {
        return this.chromStart;
    }

    public int getChromEnd() {
        return this.chromEnd;
    }

    public int getBasesCovered() {
        return this.basesCovered;
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public float getSumData() {
        return this.sumData;
    }

    public float getMeanVal() {
        return this.basesCovered == 0 ? 0.0f : this.sumData / (float)this.basesCovered;
    }

    public float getSumSquares() {
        return this.sumSquares;
    }

    public void print() {
        log.debug((Object)("Zoom data record (Table DD) number " + this.recordNumber + " for zoom level " + this.zoomLevel));
        log.debug((Object)("ChromName = " + this.chromName));
        log.debug((Object)("ChromId = " + this.chromId));
        log.debug((Object)("ChromStart = " + this.chromStart));
        log.debug((Object)("ChromEnd = " + this.chromEnd));
        log.debug((Object)("ValidCount = " + this.basesCovered));
        log.debug((Object)("MinVal = " + this.minVal));
        log.debug((Object)("MaxVal = " + this.maxVal));
        log.debug((Object)("Sum of data values = " + this.sumData));
        log.debug((Object)("Sum of squares values = " + this.sumSquares));
    }
}

