/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

class BinaryFileBuffer {
    public BufferedReader fbr;
    public Path p;
    private String cache;
    private boolean empty;

    public BinaryFileBuffer(Path p, Charset cs) throws IOException {
        this.p = p;
        this.fbr = Files.newBufferedReader(p, cs);
        this.reload();
    }

    public boolean empty() {
        return this.empty;
    }

    private void reload() throws IOException {
        try {
            this.cache = this.fbr.readLine();
            if (this.cache == null) {
                this.empty = true;
                this.cache = null;
            } else {
                this.empty = false;
            }
        }
        catch (EOFException e) {
            this.empty = true;
            this.cache = null;
        }
    }

    public void close() throws IOException {
        this.fbr.close();
    }

    public String peek() {
        if (this.empty()) {
            return null;
        }
        return this.cache.toString();
    }

    public String pop() throws IOException {
        String answer = this.peek();
        this.reload();
        return answer;
    }
}

