/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.FFTUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class Autocorrelation
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFileReader<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    @Parameter(names={"-m", "--max"}, description="Autocorrelation limit (bp)")
    public int limit = 200;

    @Override
    public void run() throws IOException {
        try (WigFileReader wig = WigFileReader.autodetect((Path)this.inputFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Computing autocorrelation for each window");
            int skipped = 0;
            for (Interval interval : this.loci) {
                float[] data;
                try {
                    data = wig.query(interval).getValues();
                }
                catch (WigFileException | IOException e) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++skipped;
                    continue;
                }
                float[] auto = FFTUtils.autocovariance(data, this.limit);
                writer.write(interval.toBed());
                for (int i = 0; i < auto.length; ++i) {
                    writer.write("\t" + auto[i]);
                }
                writer.newLine();
            }
            log.info((Object)("Skipped " + skipped + " intervals"));
        }
    }

    public static void main(String[] args) {
        new Autocorrelation().instanceMain(args);
    }
}

