/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BigWigFileReader;
import edu.unc.genomics.io.TextWigFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;

public abstract class WigFileReader
implements Closeable {
    private static final Logger log = Logger.getLogger(WigFileReader.class);
    protected final Path p;
    protected TrackHeader header = TrackHeader.newWiggle();

    protected WigFileReader(Path p) {
        this.p = p;
    }

    public static WigFileReader autodetect(Path p) throws IOException, WigFileFormatException {
        WigFileReader wig;
        if (BigWigFileReader.isBigWig(p)) {
            log.info((Object)("Autodetected BigWig file type: " + p));
            wig = new BigWigFileReader(p);
        } else {
            log.info((Object)("Autodetected Wiggle file type: " + p));
            wig = new TextWigFileReader(p);
        }
        return wig;
    }

    public final Path getPath() {
        return this.p;
    }

    public final TrackHeader getHeader() {
        return this.header;
    }

    public abstract Contig query(Interval var1) throws IOException, WigFileException;

    public final Contig query(String chr, int start, int stop) throws IOException, WigFileException {
        return this.query(new Interval(chr, start, stop));
    }

    public abstract SummaryStatistics queryStats(Interval var1) throws IOException, WigFileException;

    public final SummaryStatistics queryStats(String chr, int start, int stop) throws IOException, WigFileException {
        return this.queryStats(new Interval(chr, start, stop));
    }

    public abstract Set<String> chromosomes();

    public abstract int getChrStart(String var1);

    public abstract int getChrStop(String var1);

    public final boolean includes(Interval i) {
        return this.includes(i.getChr(), i.getStart(), i.getStop());
    }

    public abstract boolean includes(String var1, int var2, int var3);

    public abstract boolean includes(String var1);

    public abstract long numBases();

    public abstract double total();

    public abstract double mean();

    public abstract double stdev();

    public abstract double min();

    public abstract double max();

    public abstract String toString();
}

