/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.jtransforms.fft.RealFFTUtils_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class RealFFTUtils_2DTest {
    public static final String DEFAULT_MESSAGE = "FFT of size %dx%d: ";
    public static final int SEED = 20110624;
    private final int columns;
    private final DoubleFFT_2D fft2d;
    private final FloatFFT_2D fft2f;
    private final Random random;
    private final int rows;
    private final RealFFTUtils_2D unpacker;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{16, 32, 64, 128};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                arrayList.add(new Object[]{nArray[i], nArray[j], 1, 20110624});
                arrayList.add(new Object[]{nArray[i], nArray[j], 4, 20110624});
            }
        }
        return arrayList;
    }

    public RealFFTUtils_2DTest(int n, int n2, int n3, long l) {
        this.rows = n;
        this.columns = n2;
        this.fft2d = new DoubleFFT_2D(n, n2);
        this.fft2f = new FloatFFT_2D(n, n2);
        this.random = new Random(l);
        this.unpacker = new RealFFTUtils_2D(n, n2);
        ConcurrencyUtils.setNumberOfThreads(n3);
    }

    public FloatingPointEqualityChecker createEqualityChecker(double d, double d2) {
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns);
        return new FloatingPointEqualityChecker(string, d, d2, 0.0f, 0.0f);
    }

    public FloatingPointEqualityChecker createEqualityChecker(float f, float f2) {
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns);
        return new FloatingPointEqualityChecker(string, 0.0, 0.0, f, f2);
    }

    @Test
    public void testUnpack1dInput() {
        double d;
        double d2 = 1.0E-8;
        double d3 = 0.005;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[this.rows * this.columns];
        double[][] dArray2 = new double[this.rows][2 * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                dArray[i * this.columns + j] = d = this.random.nextDouble();
                dArray2[i][2 * j] = d;
                dArray2[i][2 * j + 1] = 0.0;
            }
        }
        this.fft2d.complexForward(dArray2);
        this.fft2d.realForward(dArray);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                String string = String.format("[%d][%d]", i, j);
                double d5 = dArray2[i][j];
                d = this.unpacker.unpack(i, j, dArray, 0);
                floatingPointEqualityChecker.assertEquals(string, d5, d);
            }
        }
    }

    @Test
    public void testUnpack1fInput() {
        float f = 0.1f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.rows * this.columns];
        float[][] fArray2 = new float[this.rows][2 * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f4;
                fArray[i * this.columns + j] = f4 = this.random.nextFloat();
                fArray2[i][2 * j] = f4;
                fArray2[i][2 * j + 1] = 0.0f;
            }
        }
        this.fft2f.complexForward(fArray2);
        this.fft2f.realForward(fArray);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                String string = String.format("[%d][%d]", i, j);
                float f5 = fArray2[i][j];
                float f6 = this.unpacker.unpack(i, j, fArray, 0);
                floatingPointEqualityChecker.assertEquals(string, f5, f6);
            }
        }
    }

    @Test
    public void testUnpack2dInput() {
        double d;
        double d2 = 1.0E-8;
        double d3 = 0.005;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.rows][this.columns];
        double[][] dArray2 = new double[this.rows][2 * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                dArray[i][j] = d = this.random.nextDouble();
                dArray2[i][2 * j] = d;
                dArray2[i][2 * j + 1] = 0.0;
            }
        }
        this.fft2d.complexForward(dArray2);
        this.fft2d.realForward(dArray);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                String string = String.format("[%d][%d]", i, j);
                double d5 = dArray2[i][j];
                d = this.unpacker.unpack(i, j, dArray);
                floatingPointEqualityChecker.assertEquals(string, d5, d);
                d5 = dArray2[i][j];
                d = this.unpacker.unpack(i, j, dArray);
            }
        }
    }

    @Test
    public void testUnpack2fInput() {
        float f = 0.1f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[][] fArray = new float[this.rows][this.columns];
        float[][] fArray2 = new float[this.rows][2 * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f4;
                fArray[i][j] = f4 = this.random.nextFloat();
                fArray2[i][2 * j] = f4;
                fArray2[i][2 * j + 1] = 0.0f;
            }
        }
        this.fft2f.complexForward(fArray2);
        this.fft2f.realForward(fArray);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                String string = String.format("[%d][%d]", i, j);
                float f5 = fArray2[i][j];
                float f6 = this.unpacker.unpack(i, j, fArray);
                floatingPointEqualityChecker.assertEquals(string, f5, f6);
                f5 = fArray2[i][j];
                f6 = this.unpacker.unpack(i, j, fArray);
            }
        }
    }

    @Test
    public void testPack1dInput() {
        double[] dArray = new double[this.rows * this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns) + "[%d][%d]";
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                double d = this.random.nextDouble();
                try {
                    this.unpacker.pack(d, i, j, dArray, 0);
                    double d2 = this.unpacker.unpack(i, j, dArray, 0);
                    Assert.assertEquals((String)String.format(string, i, j), (double)d, (double)d2, (double)0.0);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testPack1fInput() {
        float[] fArray = new float[this.rows * this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns) + "[%d][%d]";
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                float f = this.random.nextFloat();
                try {
                    this.unpacker.pack(f, i, j, fArray, 0);
                    float f2 = this.unpacker.unpack(i, j, fArray, 0);
                    Assert.assertEquals((String)String.format(string, i, j), (double)f, (double)f2, (double)0.0);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testPack2dInput() {
        double[][] dArray = new double[this.rows][this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns) + "[%d][%d]";
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                double d = this.random.nextDouble();
                try {
                    this.unpacker.pack(d, i, j, dArray);
                    double d2 = this.unpacker.unpack(i, j, dArray);
                    Assert.assertEquals((String)String.format(string, i, j), (double)d, (double)d2, (double)0.0);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testPack2fInput() {
        float[][] fArray = new float[this.rows][this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.rows, this.columns) + "[%d][%d]";
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 2 * this.columns; ++j) {
                float f = this.random.nextFloat();
                try {
                    this.unpacker.pack(f, i, j, fArray);
                    float f2 = this.unpacker.unpack(i, j, fArray);
                    Assert.assertEquals((String)String.format(string, i, j), (double)f, (double)f2, (double)0.0);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

