/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.WigItem;

public class BigWigFile
extends WigFile {
    private BBFileReader reader;
    private BBTotalSummaryBlock summary;

    public BigWigFile(Path p) throws IOException {
        super(p);
        this.reader = new BBFileReader(p.toString());
        this.summary = this.reader.getTotalSummaryBlock();
    }

    public static boolean isBigWig(Path p) throws IOException {
        boolean isBigWig = false;
        try {
            BBFileReader reader = new BBFileReader(p.toString());
            isBigWig = reader.isBigWigFile();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return isBigWig;
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<WigItem> query(String chr, int low, int high) throws WigFileException {
        if (!this.includes(chr, low, high)) {
            throw new WigFileException("BigWigFile does not contain data for region: " + chr + ":" + low + "-" + high);
        }
        return new BigWigCoordinateChangeIterator(this.reader.getBigWigIterator(chr, low - 1, chr, high, false));
    }

    @Override
    public Set<String> chromosomes() {
        return new HashSet<String>(this.reader.getChromosomeNames());
    }

    @Override
    public int getChrStart(String chr) {
        int chrID = this.reader.getChromosomeID(chr);
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getStartBase() + 1;
    }

    @Override
    public int getChrStop(String chr) {
        int chrID = this.reader.getChromosomeID(chr);
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getEndBase();
    }

    @Override
    public boolean includes(String chr, int start, int stop) {
        int chrID = this.reader.getChromosomeID(chr);
        if (chrID == -1) {
            return false;
        }
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getStartBase() <= start && region.getEndBase() >= stop;
    }

    @Override
    public boolean includes(String chr) {
        return this.reader.getChromosomeID(chr) != -1;
    }

    @Override
    public long numBases() {
        return this.summary.getBasesCovered();
    }

    @Override
    public double total() {
        return this.summary.getSumData();
    }

    @Override
    public double mean() {
        return this.total() / (double)this.numBases();
    }

    @Override
    public double stdev() {
        return Math.sqrt((double)(this.summary.getSumSquares() / (float)this.numBases()) - Math.pow(this.mean(), 2.0));
    }

    @Override
    public double min() {
        return this.summary.getMinVal();
    }

    @Override
    public double max() {
        return this.summary.getMaxVal();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("BigWig file:\n");
        for (String chr : this.chromosomes()) {
            s.append("Chromosome ").append(chr).append(", start=").append(this.getChrStart(chr));
            s.append(", stop=").append(this.getChrStop(chr)).append("\n");
        }
        s.append("Basic Statistics:\n");
        s.append("\tMean:\t\t\t").append(this.mean()).append("\n");
        s.append("\tStandard Deviation:\t").append(this.stdev()).append("\n");
        s.append("\tTotal:\t\t\t").append(this.total()).append("\n");
        s.append("\tBases Covered:\t\t").append(this.numBases()).append("\n");
        s.append("\tMin value:\t\t").append(this.min()).append("\n");
        s.append("\tMax value:\t\t").append(this.max());
        return s.toString();
    }

    private static class BigWigCoordinateChangeIterator
    implements Iterator<WigItem> {
        private final BigWigIterator bwIter;

        private BigWigCoordinateChangeIterator(BigWigIterator bwIter) {
            this.bwIter = bwIter;
        }

        @Override
        public boolean hasNext() {
            return this.bwIter.hasNext();
        }

        @Override
        public WigItem next() {
            WigItem item = this.bwIter.next();
            WigItem shifted = new WigItem(item.getItemNumber(), item.getChromosome(), item.getStartBase() + 1, item.getEndBase(), item.getWigValue());
            return shifted;
        }

        @Override
        public void remove() {
            this.bwIter.remove();
        }
    }
}

