/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsc.genome;

import edu.ucsc.genome.TrackHeaderException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrackHeader {
    protected String type;
    protected String name;
    protected String description;
    protected String visibility;
    protected Short[] color;
    protected Short[] altColor;
    protected Short priority;
    protected Boolean autoScale;
    protected Boolean alwaysZero;
    protected Boolean gridDefault;
    protected Integer[] maxHeightPixels;
    protected String graphType;
    protected Double[] viewLimits;
    protected Double yLineMark;
    protected Boolean yLineOnOff;
    protected String windowingFunction;
    protected Byte smoothingWindow;
    protected Boolean itemRgb;
    protected String colorByStrand;
    protected Boolean useScore;
    protected String group;
    protected String db;
    protected String url;
    protected String htmlUrl;
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\b[\\w]*=(\".*\"|'.*'|\\S*)");

    public TrackHeader(String type) {
        this.type = type;
    }

    public TrackHeader() {
        this(null);
    }

    public static TrackHeader parse(String line) throws TrackHeaderException {
        TrackHeader header = new TrackHeader();
        Matcher m = ATTRIBUTE_PATTERN.matcher(line);
        while (m.find()) {
            char lastChar;
            String token = m.group();
            int delim = token.indexOf(61);
            if (delim == -1) {
                throw new TrackHeaderException("Invalid token: '" + token + "' in UCSC track header");
            }
            String key = token.substring(0, delim);
            String value = token.substring(delim + 1);
            char firstChar = value.charAt(0);
            if (firstChar == '\"' || firstChar == '\'') {
                value = value.substring(1);
            }
            if ((lastChar = value.charAt(value.length() - 1)) == '\"' || lastChar == '\'') {
                value = value.substring(0, value.length() - 1);
            }
            try {
                switch (key) {
                    case "type": {
                        header.setType(value);
                        break;
                    }
                    case "name": {
                        header.setName(value);
                        break;
                    }
                    case "description": {
                        header.setDescription(value);
                        break;
                    }
                    case "visibility": {
                        header.setVisibility(value);
                        break;
                    }
                    case "color": {
                        String[] rgb = value.split(":");
                        header.setColor(Short.parseShort(rgb[0]), Short.parseShort(rgb[1]), Short.parseShort(rgb[2]));
                        break;
                    }
                    case "altColor": {
                        String[] altrgb = value.split(":");
                        header.setColor(Short.parseShort(altrgb[0]), Short.parseShort(altrgb[1]), Short.parseShort(altrgb[2]));
                        break;
                    }
                    case "priority": {
                        header.setPriority(Short.parseShort(value));
                        break;
                    }
                    case "autoScale": {
                        header.setAutoScale(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "alwaysZero": {
                        header.setAlwaysZero(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "gridDefault": {
                        header.setGridDefault(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "maxHeightPixels": {
                        String[] mdm = value.split(":");
                        header.setMaxHeightPixels(Integer.parseInt(mdm[0]), Integer.parseInt(mdm[1]), Integer.parseInt(mdm[2]));
                        break;
                    }
                    case "graphType": {
                        header.setGraphType(value);
                        break;
                    }
                    case "viewLimits": {
                        String[] limits = value.split(":");
                        header.setViewLimits(Double.parseDouble(limits[0]), Double.parseDouble(limits[1]));
                        break;
                    }
                    case "yLineMark": {
                        header.setyLineMark(Double.parseDouble(value));
                        break;
                    }
                    case "yLineOnOff": {
                        header.setyLineOnOff(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "windowingFunction": {
                        header.setWindowingFunction(value);
                        break;
                    }
                    case "smoothingWindow": {
                        header.setSmoothingWindow(Byte.parseByte(value));
                        break;
                    }
                    case "itemRgb": {
                        header.setItemRgb(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "colorByStrand": {
                        header.setColorByStrand(value);
                        break;
                    }
                    case "useScore": {
                        header.setUseScore(TrackHeader.parseBoolean(value));
                        break;
                    }
                    case "group": {
                        header.setGroup(value);
                        break;
                    }
                    case "db": {
                        header.setDb(value);
                        break;
                    }
                    case "url": {
                        header.setUrl(value);
                        break;
                    }
                    case "htmlUrl": {
                        header.setHtmlUrl(value);
                        break;
                    }
                    default: {
                        throw new TrackHeaderException("Unknown track attribute: " + key);
                    }
                }
            }
            catch (Exception e) {
                throw new TrackHeaderException("Invalid or unknown attribute: " + token);
            }
        }
        return header;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("track");
        if (this.type != null) {
            s.append(" type=").append(this.type);
        }
        if (this.name != null) {
            s.append(" name='").append(this.name).append("'");
        }
        if (this.description != null) {
            s.append(" description='").append(this.description).append("'");
        }
        if (this.autoScale != null) {
            String autoScaleStr = this.autoScale != false ? "on" : "off";
            s.append(" autoScale=").append(autoScaleStr);
        }
        if (this.visibility != null) {
            s.append(" visibility=").append(this.visibility);
        }
        if (this.viewLimits != null) {
            s.append(" viewLimits=").append(this.viewLimits[0]).append(":").append(this.viewLimits[1]);
        }
        if (this.color != null) {
            s.append(" color=").append(this.color);
        }
        if (this.altColor != null) {
            s.append(" altColor=").append(this.altColor);
        }
        if (this.priority != null) {
            s.append(" priority=").append(this.priority);
        }
        if (this.alwaysZero != null) {
            s.append(" color=").append(this.color);
        }
        return s.toString();
    }

    private static boolean parseBoolean(String value) {
        return value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public Short[] getColor() {
        return this.color;
    }

    public void setColor(short red, short green, short blue) {
        this.color = new Short[3];
        this.color[0] = red;
        this.color[1] = green;
        this.color[2] = blue;
    }

    public Short[] getAltColor() {
        return this.altColor;
    }

    public void setAltColor(short red, short green, short blue) {
        this.altColor = new Short[3];
        this.altColor[0] = red;
        this.altColor[1] = green;
        this.altColor[2] = blue;
    }

    public Short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isAlwaysZero() {
        return this.alwaysZero;
    }

    public void setAlwaysZero(boolean alwaysZero) {
        this.alwaysZero = alwaysZero;
    }

    public Boolean getGridDefault() {
        return this.gridDefault;
    }

    public void setGridDefault(boolean gridDefault) {
        this.gridDefault = gridDefault;
    }

    public Integer[] getMaxHeightPixels() {
        return this.maxHeightPixels;
    }

    public void setMaxHeightPixels(int maxHeight, int defaultHeight, int minHeight) {
        this.maxHeightPixels = new Integer[3];
        this.maxHeightPixels[0] = maxHeight;
        this.maxHeightPixels[1] = defaultHeight;
        this.maxHeightPixels[2] = minHeight;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public Double[] getViewLimits() {
        return this.viewLimits;
    }

    public void setViewLimits(double min, double max) {
        this.viewLimits = new Double[2];
        this.viewLimits[0] = min;
        this.viewLimits[1] = max;
    }

    public Double isyLineMark() {
        return this.yLineMark;
    }

    public void setyLineMark(double yLineMark) {
        this.yLineMark = yLineMark;
    }

    public boolean isyLineOnOff() {
        return this.yLineOnOff;
    }

    public void setyLineOnOff(boolean yLineOnOff) {
        this.yLineOnOff = yLineOnOff;
    }

    public String getWindowingFunction() {
        return this.windowingFunction;
    }

    public void setWindowingFunction(String windowingFunction) {
        this.windowingFunction = windowingFunction;
    }

    public Byte getSmoothingWindow() {
        return this.smoothingWindow;
    }

    public void setSmoothingWindow(byte smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
    }

    public Boolean getItemRgb() {
        return this.itemRgb;
    }

    public void setItemRgb(boolean itemRgb) {
        this.itemRgb = itemRgb;
    }

    public String getColorByStrand() {
        return this.colorByStrand;
    }

    public void setColorByStrand(String colorByStrand) {
        this.colorByStrand = colorByStrand;
    }

    public Boolean getUseScore() {
        return this.useScore;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public void setHtmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
    }
}

