/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import edu.unc.genomics.ResourceManager;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.apache.log4j.Logger;

public class AssemblyManager {
    private static final Logger log = Logger.getLogger(AssemblyManager.class);
    private static Assembly lastUsed;

    public static List<Assembly> getAvailableAssemblies() {
        ArrayList<Assembly> arrayList = new ArrayList<Assembly>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(ResourceManager.getAssembliesDirectory(), "*.{len}");){
            for (Path path : directoryStream) {
                log.debug((Object)("Loading assembly: " + path));
                try {
                    Assembly assembly = new Assembly(path);
                    arrayList.add(assembly);
                }
                catch (IOException | DataFormatException exception) {
                    log.warn((Object)("Error loading assembly: " + path));
                }
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error listing assemblies");
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static void deleteAssembly(Assembly assembly) throws IOException {
        Files.deleteIfExists(assembly.getPath());
    }

    public static Assembly loadCustomAssembly(Path path) throws IOException, DataFormatException {
        log.debug((Object)("Loading custom assembly from file: " + path));
        Assembly assembly = new Assembly(path);
        Files.copy(path, ResourceManager.getAssembliesDirectory().resolve(path.getFileName()), new CopyOption[0]);
        return assembly;
    }

    public static Assembly getLastUsed() {
        return lastUsed;
    }

    public static void setLastUsed(Assembly assembly) {
        lastUsed = assembly;
    }
}

