/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.JobException;
import edu.unc.genomics.ThreadFilter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;

public class Job
implements Iterable<ParameterDescription>,
Runnable {
    private static final Logger log = Logger.getLogger(Job.class);
    private final Class<? extends CommandLineTool> tool;
    private final CommandLineTool app;
    private final List<ParameterDescription> parameters;
    private final String usageText;
    private boolean isRunning = false;
    private StringWriter writer = new StringWriter();
    private Map<ParameterDescription, String> args = new HashMap<ParameterDescription, String>();

    public Job(Class<? extends CommandLineTool> clazz) throws InstantiationException, IllegalAccessException {
        this.tool = clazz;
        this.app = clazz.newInstance();
        JCommander jCommander = new JCommander((Object)this.app);
        jCommander.setProgramName(clazz.getSimpleName());
        this.parameters = jCommander.getParameters();
        StringBuilder stringBuilder = new StringBuilder();
        jCommander.usage(stringBuilder);
        this.usageText = stringBuilder.toString();
        for (ParameterDescription parameterDescription : this.parameters) {
            if (parameterDescription.getDefault() == null) continue;
            this.setArgument(parameterDescription, String.valueOf(parameterDescription.getDefault()));
        }
    }

    public Job(Job job) {
        this.tool = job.tool;
        this.app = job.app;
        this.parameters = job.parameters;
        this.args = job.args;
        this.usageText = job.usageText;
    }

    @Override
    public void run() {
        String[] stringArray;
        try {
            stringArray = this.getArguments();
        }
        catch (JobException jobException) {
            jobException.printStackTrace();
            throw new CommandLineToolException("Job arguments are not valid");
        }
        WriterAppender writerAppender = new WriterAppender((Layout)new PatternLayout(), (Writer)this.writer);
        writerAppender.addFilter((Filter)new ThreadFilter(Thread.currentThread().getName()));
        Logger.getRootLogger().addAppender((Appender)writerAppender);
        this.isRunning = true;
        this.app.toolRunnerMain(stringArray);
        this.isRunning = false;
        Logger.getRootLogger().removeAppender((Appender)writerAppender);
    }

    public String[] getArguments() throws JobException {
        if (!this.validateArguments()) {
            throw new JobException("Job Arguments are not valid");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterDescription parameterDescription : this.args.keySet()) {
            arrayList.add(parameterDescription.getLongestName());
            arrayList.add(this.args.get(parameterDescription));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String getArgument(ParameterDescription parameterDescription) {
        return this.args.get(parameterDescription);
    }

    public void setArgument(ParameterDescription parameterDescription, String string) {
        if (string.length() == 0) {
            this.args.remove(parameterDescription);
        } else {
            this.args.put(parameterDescription, string);
        }
    }

    public void resetArguments() {
        this.args.clear();
    }

    public boolean isSet(ParameterDescription parameterDescription) {
        return this.args.containsKey(parameterDescription);
    }

    public boolean validateArguments() {
        boolean bl = true;
        for (ParameterDescription parameterDescription : this.parameters) {
            if (!parameterDescription.getParameter().required() || this.isSet(parameterDescription)) continue;
            log.debug((Object)("Job is missing required argument: " + parameterDescription.getLongestName()));
            bl = false;
        }
        return bl;
    }

    public int numParameters() {
        return this.parameters.size();
    }

    @Override
    public Iterator<ParameterDescription> iterator() {
        return this.parameters.iterator();
    }

    public String getName() {
        return this.tool.getSimpleName();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public String toString() {
        return this.getName();
    }

    public String getOutput() {
        return this.writer.toString();
    }
}

