/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RollingReadLength
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(RollingReadLength.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing output file");
        int n = 0;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader trackHeader = new TrackHeader("wiggle_0");
            trackHeader.setName("Converted " + this.intervalFile.getPath().getFileName());
            trackHeader.setDescription("Converted " + this.intervalFile.getPath().getFileName());
            bufferedWriter.write(trackHeader.toString());
            bufferedWriter.newLine();
            for (String string : this.assembly) {
                log.debug((Object)("Processing chromosome " + string));
                bufferedWriter.write("fixedStep chrom=" + string + " start=1 step=1 span=1");
                bufferedWriter.newLine();
                int n2 = 1;
                while (n2 < this.assembly.getChrLength(string)) {
                    int n3 = n2 + 500000 - 1;
                    int n4 = n3 - n2 + 1;
                    int[] nArray = new int[n4];
                    int[] nArray2 = new int[n4];
                    Iterator iterator = this.intervalFile.query(string, n2, n3);
                    while (iterator.hasNext()) {
                        Interval interval = (Interval)iterator.next();
                        for (int i = interval.getStart(); i <= interval.getStop(); ++i) {
                            int n5 = i - n2;
                            nArray[n5] = nArray[n5] + interval.length();
                            int n6 = i - n2;
                            nArray2[n6] = nArray2[n6] + 1;
                        }
                        ++n;
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray2[i] == 0) {
                            bufferedWriter.write(String.valueOf(Float.NaN));
                        } else {
                            bufferedWriter.write(String.valueOf(nArray[i] / nArray2[i]));
                        }
                        bufferedWriter.newLine();
                    }
                    n2 = n3 + 1;
                }
            }
        }
        log.info((Object)("Mapped " + n + " reads"));
    }

    public static void main(String[] stringArray) {
        new RollingReadLength().instanceMain(stringArray);
    }
}

