/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class FindAbsoluteMaxima
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindAbsoluteMaxima.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private List<WigFile> wigs = new ArrayList<WigFile>();

    @Override
    public void run() throws IOException {
        Object object;
        log.debug((Object)"Initializing input Wig file(s)");
        for (String string : this.inputFiles) {
            try {
                object = WigFile.autodetect((Path)Paths.get(string, new String[0]));
                this.wigs.add((WigFile)object);
            }
            catch (WigFileException wigFileException) {
                log.error((Object)("Error initializing Wig input file: " + string));
                wigFileException.printStackTrace();
                throw new RuntimeException("Error initializing Wig input file: " + string);
            }
        }
        log.debug((Object)"Initializing output file");
        int n = 0;
        int n2 = 0;
        object = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        Throwable throwable4 = null;
        try {
            ((Writer)object).write("#Chr\tStart\tStop\tID\tValue\tStrand");
            for (String string : this.inputFiles) {
                Path path = Paths.get(string, new String[0]);
                ((Writer)object).write("\t" + path.getFileName().toString());
            }
            ((BufferedWriter)object).newLine();
            log.debug((Object)"Iterating over all intervals and finding maxima");
            for (String string : this.lociFile) {
                ((Writer)object).write(string.toBed());
                for (WigFile wigFile : this.wigs) {
                    float f = -3.4028235E38f;
                    int n3 = -1;
                    try {
                        Iterator iterator = wigFile.query((Interval)string);
                        while (iterator.hasNext()) {
                            WigItem wigItem = (WigItem)iterator.next();
                            if (!(wigItem.getWigValue() > f)) continue;
                            f = wigItem.getWigValue();
                            n3 = (wigItem.getStartBase() + wigItem.getEndBase()) / 2;
                        }
                        ((Writer)object).write("\t" + n3);
                    }
                    catch (WigFileException wigFileException) {
                        ((Writer)object).write("\tNaN");
                        ++n2;
                    }
                }
                ((BufferedWriter)object).newLine();
                ++n;
            }
        }
        catch (Throwable throwable2) {
            throwable4 = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable4 != null) {
                    try {
                        ((BufferedWriter)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable4.addSuppressed(throwable3);
                    }
                } else {
                    ((BufferedWriter)object).close();
                }
            }
        }
        this.lociFile.close();
        for (Throwable throwable4 : this.wigs) {
            throwable4.close();
        }
        log.info((Object)(n + " intervals processed"));
        log.info((Object)(n2 + " interval skipped"));
    }

    public static void main(String[] stringArray) {
        new FindAbsoluteMaxima().instanceMain(stringArray);
    }
}

