/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Subtract
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Subtract.class);
    @Parameter(names={"-m", "--minuend"}, description="Minuend (top - file 1)", required=true)
    public WigFile minuendFile;
    @Parameter(names={"-s", "--subtrahend"}, description="Subtrahend (bottom - file 2)", required=true)
    public WigFile subtrahendFile;

    @Override
    public void setup() {
        log.debug((Object)"Initializing input files");
        this.inputs.add(this.minuendFile);
        this.inputs.add(this.subtrahendFile);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + string + ":" + n + "-" + n2));
        Iterator iterator = this.minuendFile.query(string, n, n2);
        Iterator iterator2 = this.subtrahendFile.query(string, n, n2);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n, (int)n2);
        while (iterator2.hasNext()) {
            WigItem wigItem = (WigItem)iterator2.next();
            for (int i = wigItem.getStartBase(); i <= wigItem.getEndBase(); ++i) {
                if (i - n < 0 || i - n >= fArray.length) continue;
                int n3 = i - n;
                fArray[n3] = fArray[n3] - wigItem.getWigValue();
            }
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new Subtract().instanceMain(stringArray);
    }
}

