/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import edu.unc.genomics.AssemblyManager;
import edu.unc.genomics.AssemblyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.DataFormatException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AssemblyManagerDialog
extends JDialog {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 500;
    private static final long serialVersionUID = -1461628562713621064L;
    private static final Logger log = Logger.getLogger(AssemblyManagerDialog.class);
    private final JPanel contentPanel = new JPanel();
    private final JFileChooser fcCustomAssembly = new JFileChooser();
    private final JTable assembliesTable = new JTable();
    private AssemblyTableModel model;

    public AssemblyManagerDialog(JFrame jFrame) {
        super(jFrame, "Assembly Manager", true);
        this.setSize(400, 500);
        int n = jFrame.getX() + (jFrame.getWidth() - this.getWidth()) / 2;
        int n2 = jFrame.getY() + (jFrame.getHeight() - this.getHeight()) / 2;
        this.setLocation(n, n2);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.model = new AssemblyTableModel(AssemblyManager.getAvailableAssemblies());
        this.assembliesTable.setModel(this.model);
        this.assembliesTable.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.assembliesTable);
        this.assembliesTable.setFillsViewportHeight(true);
        this.contentPanel.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        JButton jButton = new JButton("Remove");
        jButton.setActionCommand("RemoveAssembly");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssemblyManagerDialog.this.removeCustomAssembly();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Load Custom Assembly");
        jButton2.setActionCommand("LoadAssembly");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssemblyManagerDialog.this.loadCustomAssembly();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Done");
        jButton3.setActionCommand("Done");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssemblyManagerDialog.this.closeDialog();
            }
        });
        jPanel.add(jButton3);
        this.getRootPane().setDefaultButton(jButton3);
    }

    private void removeCustomAssembly() {
        for (int n : this.assembliesTable.getSelectedRows()) {
            try {
                Assembly assembly = this.model.getRow(n);
                AssemblyManager.deleteAssembly(assembly);
                this.model.removeRow(n);
            }
            catch (IOException iOException) {
                log.error((Object)"Error deleting Assembly");
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error deleting assembly", "Assembly Manager Error", 0);
            }
        }
    }

    private void loadCustomAssembly() {
        int n = this.fcCustomAssembly.showOpenDialog(this);
        if (n == 0) {
            Path path = this.fcCustomAssembly.getSelectedFile().toPath();
            try {
                Assembly assembly = AssemblyManager.loadCustomAssembly(path);
                this.model.addAssembly(assembly);
            }
            catch (IOException | DataFormatException exception) {
                log.error((Object)("Error loading custom assembly: " + path));
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading custom assembly", "Assembly Manager Error", 0);
            }
        }
    }

    private void closeDialog() {
        this.dispose();
    }
}

