/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AssemblyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8225453782461913732L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "# Contigs"};
    private final List<Assembly> assemblies;

    public AssemblyTableModel(List<Assembly> list) {
        this.assemblies = list;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.assemblies.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Assembly assembly = this.assemblies.get(n);
        if (n2 == 0) {
            return assembly.toString();
        }
        if (n2 == 1) {
            return assembly.chromosomes().size();
        }
        return null;
    }

    public Assembly getRow(int n) {
        return this.assemblies.get(n);
    }

    public boolean containsAssembly(Assembly assembly) {
        String string = assembly.toString();
        for (Assembly assembly2 : this.assemblies) {
            if (!assembly2.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void addAssembly(Assembly assembly) {
        this.assemblies.add(assembly);
        this.fireTableRowsInserted(this.assemblies.size() - 1, this.assemblies.size() - 1);
    }

    public void removeRow(int n) {
        this.assemblies.remove(n);
        this.fireTableRowsDeleted(n, n);
    }
}

