/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ResourceManager;
import edu.unc.genomics.ToolsTreeNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolsTreeModel
extends DefaultTreeModel {
    public static final Path DEFAULT_CONFIGURATION_FILE = Paths.get("toolConf.xml", new String[0]);
    private static final Logger log = Logger.getLogger(ToolsTreeModel.class);
    private static final long serialVersionUID = -6587614270922489960L;

    public ToolsTreeModel() {
        super(new DefaultMutableTreeNode("Tools"));
    }

    public static ToolsTreeModel loadDefaultConfig() throws ClassNotFoundException, ParserConfigurationException, SAXException, IOException {
        return ToolsTreeModel.loadConfig(ResourceManager.getResourceDirectory().resolve(DEFAULT_CONFIGURATION_FILE));
    }

    public static ToolsTreeModel loadConfig(Path path) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        ToolsTreeModel toolsTreeModel = new ToolsTreeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)toolsTreeModel.getRoot();
        log.debug((Object)("Loading tools from: " + DEFAULT_CONFIGURATION_FILE.toAbsolutePath()));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(path.toFile());
        NodeList nodeList = document.getElementsByTagName("section");
        log.debug((Object)("Found " + nodeList.getLength() + " sections"));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getAttributes().getNamedItem("name").getNodeValue();
            log.debug((Object)("Loading section: " + string));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("tool")) continue;
                String string2 = node2.getAttributes().getNamedItem("name").getNodeValue();
                log.debug((Object)("Loading tool: " + string2));
                String string3 = node2.getAttributes().getNamedItem("class").getNodeValue();
                Class<?> clazz = Class.forName(string3);
                ToolsTreeNode toolsTreeNode = new ToolsTreeNode(string2, clazz);
                defaultMutableTreeNode2.add(toolsTreeNode);
            }
        }
        return toolsTreeModel;
    }
}

