/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileSnifferException;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.visualization.KMeansRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math.stat.clustering.Cluster;
import org.apache.commons.math.stat.clustering.KMeansPlusPlusClusterer;
import org.apache.log4j.Logger;

public class KMeans
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(KMeans.class);
    @Parameter(names={"-i", "--input"}, description="Input file (matrix2png format)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-k", "--clusters"}, description="Number of clusters")
    public int k = 10;
    @Parameter(names={"-1", "--min"}, description="Minimum column to use for clustering")
    public int minCol = 1;
    @Parameter(names={"-2", "--max"}, description="Maximum column to use for clustering")
    public Integer maxCol;
    @Parameter(names={"-o", "--output"}, description="Output file (clustered matrix2png format)", required=true)
    public Path outputFile;
    private Map<String, String> rows = new HashMap<String, String>();
    private List<KMeansRow> data = new ArrayList<KMeansRow>();

    @Override
    public void run() throws IOException {
        int n;
        int n2;
        Object object;
        log.debug((Object)"Loading data from the input matrix");
        String string = "";
        try (Object object2 = Files.newBufferedReader(this.inputFile, Charset.defaultCharset());){
            int n3 = 1;
            string = ((BufferedReader)object2).readLine();
            int n4 = StringUtils.countMatches((CharSequence)string, (CharSequence)"\t");
            if (this.maxCol != null || this.maxCol == -1) {
                if (this.maxCol > n4) {
                    throw new RuntimeException("Invalid range of data specified for clustering (" + this.maxCol + " > " + n4 + ")");
                }
            } else {
                this.maxCol = n4;
            }
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                ++n3;
                if (StringUtils.countMatches((CharSequence)object, (CharSequence)"\t") != n4) {
                    throw new RuntimeException("Irregular input matrix does not have same number of columns on line " + n3);
                }
                n2 = ((String)object).indexOf(9);
                String string2 = ((String)object).substring(0, n2);
                String[] stringArray = ((String)object).substring(n2 + 1).split("\t");
                Cluster cluster = Arrays.copyOfRange(stringArray, this.minCol, (int)this.maxCol);
                float[] fArray = new float[((String[])cluster).length];
                for (n = 0; n < ((String[])cluster).length; ++n) {
                    try {
                        fArray[n] = Float.parseFloat(cluster[n]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        fArray[n] = Float.NaN;
                    }
                }
                this.data.add(new KMeansRow(string2, fArray));
                this.rows.put(string2, (String)object);
            }
        }
        log.debug((Object)"Clustering the data");
        object2 = new Random();
        var3_3 = new KMeansPlusPlusClusterer((Random)object2);
        List list = var3_3.cluster(this.data, this.k, 50);
        log.debug((Object)"Writing clustered data to output file");
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        object = null;
        try {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            n2 = 1;
            int n5 = 1;
            for (Cluster cluster : list) {
                int n6 = cluster.getPoints().size();
                n = n5 + n6 - 1;
                log.info((Object)("Cluster " + n2++ + ": rows " + n5 + "-" + n));
                n5 = n + 1;
                for (KMeansRow kMeansRow : cluster.getPoints()) {
                    bufferedWriter.write(this.rows.get(kMeansRow.getId()));
                    bufferedWriter.newLine();
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                if (object != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    public static void main(String[] stringArray) throws IOException, WigFileException, IntervalFileSnifferException {
        new KMeans().instanceMain(stringArray);
    }
}

