/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class MatrixAligner
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(MatrixAligner.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-m", "--max"}, description="Truncate width (base pairs)")
    public Integer maxWidth;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<BedEntry> loci;

    @Override
    public void run() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        log.debug((Object)"Loading alignment intervals");
        try (BedFile bedFile = new BedFile(this.lociFile);){
            this.loci = bedFile.loadAll();
        }
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        for (BedEntry bedEntry : this.loci) {
            n4 = Math.abs(bedEntry.getValue().intValue() - bedEntry.getStart());
            n3 = Math.abs(bedEntry.getValue().intValue() - bedEntry.getStop());
            if (n4 > n5) {
                n5 = n4;
            }
            if (n3 <= n6) continue;
            n6 = n3;
        }
        int n7 = this.loci.size();
        int n8 = n5 + n6 + 1;
        n4 = n5;
        log.info((Object)("Intervals aligned into: " + n7 + "x" + n8 + " matrix"));
        log.info((Object)("Alignment point: " + n4));
        n3 = 0;
        int n9 = n8 - 1;
        if (this.maxWidth != null && this.maxWidth < n8) {
            log.info((Object)("Truncated to: " + n7 + "x" + this.maxWidth));
            n2 = n4;
            n = n8 - n4 - 1;
            int n10 = this.maxWidth / 2;
            if (n10 < n2 && n10 < n) {
                n3 = n4 - n10;
                n9 = n4 + n10;
            } else if (n2 <= n) {
                n9 = this.maxWidth;
            } else {
                n3 = n8 - this.maxWidth;
            }
        }
        log.debug((Object)"Initializing output file");
        n2 = 0;
        n = 0;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            bufferedWriter.write("ID");
            for (int i = n3 - n4; i <= n9 - n4; ++i) {
                bufferedWriter.write("\t" + i);
            }
            bufferedWriter.newLine();
            log.debug((Object)"Iterating over all intervals");
            Object[] objectArray = new String[n8];
            for (BedEntry bedEntry : this.loci) {
                Iterator iterator = null;
                try {
                    iterator = this.inputFile.query((Interval)bedEntry);
                }
                catch (WigFileException wigFileException) {
                    ++n;
                    continue;
                }
                float[] fArray = WigFile.flattenData((Iterator)iterator, (int)bedEntry.getStart(), (int)bedEntry.getStop());
                if (bedEntry.isCrick()) {
                    ArrayUtils.reverse((float[])fArray);
                }
                int n11 = n4 - Math.abs(bedEntry.getValue().intValue() - bedEntry.getStart());
                int n12 = n4 + Math.abs(bedEntry.getValue().intValue() - bedEntry.getStop());
                assert (fArray.length == n12 - n11 + 1);
                Arrays.fill(objectArray, "-");
                for (int i = 0; i < fArray.length; ++i) {
                    if (Float.isNaN(fArray[i])) continue;
                    objectArray[n11 + i] = String.valueOf(fArray[i]);
                }
                String string = bedEntry.getId() == null ? bedEntry.getId() : "Row " + n2++;
                bufferedWriter.write(string);
                for (int i = n3; i <= n9; ++i) {
                    bufferedWriter.write("\t" + (String)objectArray[i]);
                }
                bufferedWriter.newLine();
            }
        }
        this.inputFile.close();
        log.info((Object)(n2 + " intervals processed"));
        log.info((Object)(n + " intervals skipped"));
    }

    public static void main(String[] stringArray) {
        new MatrixAligner().instanceMain(stringArray);
    }
}

