/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class IntervalToWig
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalToWig.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Bed/BedGraph)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.info((Object)(this.intervalFile.count() + " entries in input"));
        log.debug((Object)"Initializing output file");
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader trackHeader = new TrackHeader("wiggle_0");
            trackHeader.setName("Converted " + this.intervalFile.getPath().getFileName());
            trackHeader.setDescription("Converted " + this.intervalFile.getPath().getFileName());
            bufferedWriter.write(trackHeader.toString());
            bufferedWriter.newLine();
            for (String string : this.assembly) {
                log.debug((Object)("Processing chromosome " + string));
                bufferedWriter.write("fixedStep chrom=" + string + " start=1 step=1 span=1");
                bufferedWriter.newLine();
                int n = 1;
                while (n < this.assembly.getChrLength(string)) {
                    int n2 = n + 500000 - 1;
                    int n3 = n2 - n + 1;
                    int[] nArray = new int[n3];
                    float[] fArray = new float[n3];
                    Iterator iterator = this.intervalFile.query(string, n, n2);
                    while (iterator.hasNext()) {
                        ValuedInterval valuedInterval = (ValuedInterval)iterator.next();
                        if (valuedInterval.getValue() == null) continue;
                        for (int i = valuedInterval.getStart(); i <= valuedInterval.getStop(); ++i) {
                            int n4 = i - n;
                            fArray[n4] = fArray[n4] + valuedInterval.getValue().floatValue();
                            int n5 = i - n;
                            nArray[n5] = nArray[n5] + 1;
                        }
                    }
                    for (int i = 0; i < fArray.length; ++i) {
                        if (nArray[i] == 0) {
                            bufferedWriter.write(String.valueOf(Float.NaN));
                        } else {
                            bufferedWriter.write(String.valueOf(fArray[i] / (float)nArray[i]));
                        }
                        bufferedWriter.newLine();
                    }
                    n = n2 + 1;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new IntervalToWig().instanceMain(stringArray);
    }
}

