/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PowerSpectrum
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(PowerSpectrum.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;

    private float[] abs2(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n / 2 + 1];
        fArray2[0] = fArray[0] * fArray[0] / (float)(n * n);
        if (n % 2 == 0) {
            for (int i = 1; i < n / 2; ++i) {
                fArray2[i] = fArray[2 * i] * fArray[2 * i] + fArray[2 * i + 1] * fArray[2 * i + 1];
            }
            fArray2[n / 2] = fArray[1] * fArray[1];
        } else {
            for (int i = 1; i < (n - 1) / 2; ++i) {
                fArray2[i] = fArray[2 * i] * fArray[2 * i] + fArray[2 * i + 1] * fArray[2 * i + 1];
            }
            fArray2[(n - 1) / 2] = fArray[n - 1] * fArray[n - 1] + fArray[1] * fArray[1];
        }
        return fArray2;
    }

    @Override
    public void run() throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Computing power spectrum for each window");
            int n = 0;
            for (Interval interval : this.loci) {
                int n2;
                Iterator iterator;
                try {
                    iterator = this.inputFile.query(interval);
                }
                catch (WigFileException | IOException throwable) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++n;
                    continue;
                }
                float[] fArray = WigFile.flattenData((Iterator)iterator, (int)interval.getStart(), (int)interval.getStop());
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(fArray.length);
                floatFFT_1D.realForward(fArray);
                float[] fArray2 = this.abs2(fArray);
                float f = 0.0f;
                for (n2 = 1; n2 < fArray2.length; ++n2) {
                    f += fArray2[n2];
                }
                n2 = 1;
                while (n2 < fArray2.length) {
                    int n3 = n2++;
                    fArray2[n3] = fArray2[n3] / f;
                }
                bufferedWriter.write(interval.toBed());
                for (n2 = 1; n2 < Math.min(fArray2.length, 40); ++n2) {
                    bufferedWriter.write("\t" + fArray2[n2]);
                }
                bufferedWriter.newLine();
            }
            log.info((Object)("Skipped " + n + " intervals"));
        }
    }

    public static void main(String[] stringArray) {
        new PowerSpectrum().instanceMain(stringArray);
    }
}

