/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math.stat.clustering.Clusterable;

class KMeansRow
implements Clusterable<KMeansRow>,
Serializable {
    private static final long serialVersionUID = -323598431692368500L;
    private final String id;
    private final float[] point;

    public KMeansRow(String string, float[] fArray) {
        this.point = fArray;
        this.id = string;
    }

    public float[] getPoint() {
        return this.point;
    }

    public double distanceFrom(KMeansRow kMeansRow) {
        double d = 0.0;
        float[] fArray = kMeansRow.getPoint();
        for (int i = 0; i < this.point.length; ++i) {
            d += Math.pow(this.point[i] - fArray[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public KMeansRow centroidOf(Collection<KMeansRow> collection) {
        float[] fArray = new float[this.getPoint().length];
        for (KMeansRow kMeansRow : collection) {
            for (int i = 0; i < fArray.length; ++i) {
                int n = i;
                fArray[n] = fArray[n] + kMeansRow.getPoint()[i];
            }
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / (float)collection.size();
        }
        return new KMeansRow(this.id, fArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof KMeansRow)) {
            return false;
        }
        float[] fArray = ((KMeansRow)object).getPoint();
        if (this.point.length != fArray.length) {
            return false;
        }
        for (int i = 0; i < this.point.length; ++i) {
            if (this.point[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        float[] fArray = this.point;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            Float f = Float.valueOf(fArray[i]);
            n += f.hashCode() * 13 + 7;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.id);
        for (float f : this.getPoint()) {
            stringBuilder.append("\t").append(f);
        }
        return stringBuilder.toString();
    }

    public String getId() {
        return this.id;
    }
}

