/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Average
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Average.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    int numFiles;

    @Override
    public void setup() {
        if (this.inputFiles.size() < 2) {
            throw new CommandLineToolException("No reason to add < 2 files.");
        }
        log.debug((Object)"Initializing input files");
        for (String string : this.inputFiles) {
            try {
                this.addInputFile(WigFile.autodetect((Path)Paths.get(string, new String[0])));
            }
            catch (WigFileException | IOException throwable) {
                log.error((Object)("Error initializing input Wig file: " + string));
                throwable.printStackTrace();
                throw new CommandLineToolException(throwable.getMessage());
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
        this.numFiles = this.inputs.size();
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing average for chunk " + string + ":" + n + "-" + n2));
        int n3 = n2 - n + 1;
        float[] fArray = new float[n3];
        for (WigFile wigFile : this.inputs) {
            Iterator iterator = wigFile.query(string, n, n2);
            while (iterator.hasNext()) {
                WigItem wigItem = (WigItem)iterator.next();
                for (int i = wigItem.getStartBase(); i <= wigItem.getEndBase(); ++i) {
                    if (i - n < 0 || i - n >= fArray.length) continue;
                    int n4 = i - n;
                    fArray[n4] = fArray[n4] + wigItem.getWigValue();
                }
            }
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray[i] / (float)this.numFiles;
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new Average().instanceMain(stringArray);
    }
}

