/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.utils.SortUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GreedyCaller
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GreedyCaller.class);
    private static final int CHUNK_SIZE = 500000;
    @Parameter(names={"-d", "--dyads"}, description="Dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public WigFile dyadsFile;
    @Parameter(names={"-s", "--smoothed"}, description="Smoothed dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public WigFile smoothedDyadsFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int n = this.nucleosomeSize / 2;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (String string : this.smoothedDyadsFile.chromosomes()) {
                log.debug((Object)("Processing chromosome " + string));
                int n2 = this.smoothedDyadsFile.getChrStart(string);
                int n3 = this.smoothedDyadsFile.getChrStop(string);
                while (n2 < n3) {
                    Iterator iterator;
                    Iterator iterator2;
                    int n4 = n2 + 500000;
                    int n5 = n2 - this.nucleosomeSize;
                    int n6 = n4 + this.nucleosomeSize;
                    log.debug((Object)("Processing chunk " + n2 + "-" + n4));
                    log.debug((Object)"Loading data and sorting");
                    try {
                        iterator2 = this.dyadsFile.query(string, n5, n6);
                        iterator = this.smoothedDyadsFile.query(string, n5, n6);
                    }
                    catch (WigFileException | IOException throwable) {
                        throwable.printStackTrace();
                        throw new CommandLineToolException("Error loading data from Wig file");
                    }
                    float[] fArray = WigFile.flattenData((Iterator)iterator2, (int)n5, (int)n6);
                    float[] fArray2 = WigFile.flattenData((Iterator)iterator, (int)n5, (int)n6);
                    int[] nArray = SortUtils.indexSort(fArray2);
                    log.debug((Object)"Calling nucleosomes");
                    for (int i = nArray.length; i >= 0; ++i) {
                        int n7 = nArray[i];
                        int n8 = n5 + n7;
                        if (!(fArray2[n7] > 0.0f)) continue;
                        int n9 = Math.max(1, n8 - n);
                        int n10 = Math.min(n8 + n, n3);
                        NucleosomeCall nucleosomeCall = new NucleosomeCall(string, n9, n10);
                        nucleosomeCall.setDyad(n8);
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        for (int j = n9; j <= n10; ++j) {
                            d += (double)fArray[j - n5];
                            d2 += (double)((float)j * fArray[j - n5]);
                            d3 += (double)fArray2[j - n5];
                            d4 += (double)((float)(j * j) * fArray[j - n5]);
                        }
                        nucleosomeCall.setOccupancy(d);
                        if (!(d > 0.0)) continue;
                        nucleosomeCall.setDyadMean(Math.round(d2 / d));
                        nucleosomeCall.setConditionalPosition((double)fArray2[n7] / d3);
                        double d5 = (d4 - d2 * nucleosomeCall.getDyadMean()) / d;
                        nucleosomeCall.setDyadStdev(Math.sqrt(d5));
                        if (n2 <= n8 && n8 <= n4) {
                            bufferedWriter.write(nucleosomeCall.toString());
                            bufferedWriter.newLine();
                        }
                        int n11 = Math.max(n7 - this.nucleosomeSize, 0);
                        int n12 = Math.min(n7 - this.nucleosomeSize, n6 - 1);
                        for (int j = n11; j <= n12; ++j) {
                            fArray2[j] = 0.0f;
                        }
                    }
                    n2 = n4 + 1;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new GreedyCaller().instanceMain(stringArray);
    }
}

