/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Phasogram
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Phasogram.class);
    @Parameter(names={"-i", "--input"}, description="Input wig file (read counts)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-m", "--max"}, description="Maximum phase shift", required=true)
    public int maxPhase;
    @Parameter(names={"-o", "--output"}, description="Output file (histogram)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int n;
        Object object2;
        long[] lArray = new long[this.maxPhase + 1];
        for (Object object2 : this.inputFile.chromosomes()) {
            log.debug((Object)("Processing chromosome " + (String)object2));
            n = this.inputFile.getChrStart((String)object2);
            while (n < this.inputFile.getChrStop((String)object2)) {
                int n2 = n + 500000 - 1;
                try {
                    float[] fArray = WigFile.flattenData((Iterator)this.inputFile.query((String)object2, n, n2), (int)n, (int)n2);
                    for (int i = 0; i < fArray.length - this.maxPhase; ++i) {
                        int n3 = 0;
                        while (n3 <= this.maxPhase) {
                            int n4 = n3++;
                            lArray[n4] = (long)((float)lArray[n4] + fArray[i]);
                        }
                    }
                }
                catch (WigFileException wigFileException) {
                    log.fatal((Object)"Error querying data from Wig file!");
                    wigFileException.printStackTrace();
                    throw new CommandLineToolException("Error querying data from Wig file!");
                }
                n = n2 - this.maxPhase + 1;
            }
        }
        log.debug((Object)"Writing output to disk");
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        object2 = null;
        try {
            for (n = 0; n < lArray.length; ++n) {
                bufferedWriter.write(n + "\t" + lArray[n]);
                bufferedWriter.newLine();
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                if (object2 != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new Phasogram().instanceMain(stringArray);
    }
}

