/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.ReadablePathValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class StripMatrix
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(StripMatrix.class);
    @Parameter(names={"-i", "--input"}, description="Input file (matrix2png format)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(this.inputFile, Charset.defaultCharset());
             BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            String string = bufferedReader.readLine();
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\t");
                for (int i = 1; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2.equalsIgnoreCase("-")) {
                        bufferedWriter.write("NaN");
                    } else {
                        bufferedWriter.write(string2);
                    }
                    if (i <= 1) continue;
                    bufferedWriter.write("\t");
                }
                bufferedWriter.newLine();
            }
        }
    }

    public static void main(String[] stringArray) {
        new StripMatrix().instanceMain(stringArray);
    }
}

