/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.ngs.Autocorrelation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class WigSummary
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path outputFile;

    @Override
    public void run() throws IOException {
        String string = this.inputFile.toString();
        if (this.outputFile != null) {
            log.debug((Object)"Writing to output file");
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
                bufferedWriter.write(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new WigSummary().instanceMain(stringArray);
    }
}

