/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

public class RomanNumeral {
    static final RomanValue[] ROMAN_VALUE_TABLE = new RomanValue[]{new RomanValue(1000, "M"), new RomanValue(900, "CM"), new RomanValue(500, "D"), new RomanValue(400, "CD"), new RomanValue(100, "C"), new RomanValue(90, "XC"), new RomanValue(50, "L"), new RomanValue(40, "XL"), new RomanValue(10, "X"), new RomanValue(9, "IX"), new RomanValue(5, "V"), new RomanValue(4, "IV"), new RomanValue(1, "I")};

    public static String int2roman(int n) {
        if (n >= 4000 || n < 1) {
            throw new NumberFormatException("Numbers must be in range 1-3999");
        }
        StringBuilder stringBuilder = new StringBuilder(10);
        for (RomanValue romanValue : ROMAN_VALUE_TABLE) {
            while (n >= romanValue.intVal) {
                n -= romanValue.intVal;
                stringBuilder.append(romanValue.romVal);
            }
        }
        return stringBuilder.toString();
    }

    private static class RomanValue {
        int intVal;
        String romVal;

        RomanValue(int n, String string) {
            this.intVal = n;
            this.romVal = string;
        }
    }
}

