/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.ParameterDescription;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.AssemblyManager;
import edu.unc.genomics.Job;
import edu.unc.genomics.ResourceManager;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.layout.SpringUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JobConfigPanel
extends JPanel {
    private static final long serialVersionUID = 3336295203155728629L;
    private static final Logger log = Logger.getLogger(JobConfigPanel.class);
    private static final ImageIcon fileIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("folder_page.png").toString());
    private Map<ParameterDescription, JComponent> guiMap = new HashMap<ParameterDescription, JComponent>();
    private Map<Component, ParameterDescription> jobMap = new HashMap<Component, ParameterDescription>();
    private Job job;

    public JobConfigPanel() {
        this((Job)null);
    }

    public JobConfigPanel(Job job) {
        this.setJob(job);
        this.setLayout(new SpringLayout());
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
        this.renderJob();
    }

    public void highlightInvalidArguments() {
        for (ParameterDescription parameterDescription : this.job) {
            JComponent jComponent = this.guiMap.get(parameterDescription);
            if (parameterDescription.getParameter().required() && !this.job.isSet(parameterDescription)) {
                jComponent.setBorder(BorderFactory.createLineBorder(Color.RED));
                continue;
            }
            jComponent.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void renderJob() {
        this.removeAll();
        this.guiMap.clear();
        this.jobMap.clear();
        if (this.job == null) {
            this.validate();
            this.repaint();
            return;
        }
        for (ParameterDescription parameterDescription : this.job) {
            Object object;
            Object object2;
            String string = parameterDescription.getLongestName();
            while (string.startsWith("-")) {
                string = string.substring(1);
            }
            string = StringUtils.capitalize((String)string);
            JLabel jLabel = new JLabel(string);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add(jLabel);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            this.add(jPanel);
            Field field = parameterDescription.getField();
            Class<?> clazz = field.getType();
            if (clazz.equals(Assembly.class)) {
                object2 = AssemblyManager.getAvailableAssemblies();
                object = new Assembly[object2.size()];
                object = object2.toArray((T[])object);
                final JComboBox<Assembly> jComboBox = new JComboBox<Assembly>((E[])object);
                jComboBox.setPreferredSize(new Dimension(0, 25));
                jComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, jComboBox.getPreferredSize().height));
                jComboBox.setSelectedItem(AssemblyManager.getLastUsed());
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        log.debug((Object)"Auto-databinding changed assembly into Job argument");
                        Assembly assembly = (Assembly)jComboBox.getSelectedItem();
                        AssemblyManager.setLastUsed(assembly);
                        ParameterDescription parameterDescription = (ParameterDescription)JobConfigPanel.this.jobMap.get(jComboBox);
                        JobConfigPanel.this.job.setArgument(parameterDescription, assembly.toString());
                    }
                });
                jPanel.add(jComboBox);
                this.guiMap.put(parameterDescription, jComboBox);
                this.jobMap.put(jComboBox, parameterDescription);
                continue;
            }
            object2 = new JTextField();
            if (this.job.isSet(parameterDescription)) {
                ((JTextComponent)object2).setText(this.job.getArgument(parameterDescription));
            }
            ((JComponent)object2).setPreferredSize(new Dimension(0, 20));
            ((JComponent)object2).setMaximumSize(new Dimension(Integer.MAX_VALUE, ((JTextField)object2).getPreferredSize().height));
            ((JTextComponent)object2).getDocument().addDocumentListener(new DocumentListener((JTextField)object2){
                final /* synthetic */ JTextField val$textField;
                {
                    this.val$textField = jTextField;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.pushTextToModel(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.pushTextToModel(documentEvent);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.pushTextToModel(documentEvent);
                }

                private void pushTextToModel(DocumentEvent documentEvent) {
                    log.debug((Object)"Auto-databinding changed text into Job argument");
                    Document document = documentEvent.getDocument();
                    ParameterDescription parameterDescription = (ParameterDescription)JobConfigPanel.this.jobMap.get(this.val$textField);
                    try {
                        String string = document.getText(0, document.getLength());
                        JobConfigPanel.this.job.setArgument(parameterDescription, string);
                    }
                    catch (BadLocationException badLocationException) {
                        log.error((Object)"Error pushing changed text into Job model");
                        badLocationException.printStackTrace();
                    }
                }
            });
            jPanel.add((Component)object2);
            this.guiMap.put(parameterDescription, (JComponent)object2);
            this.jobMap.put((Component)object2, parameterDescription);
            if (!clazz.equals(Path.class) && !clazz.equals(WigFile.class) && !clazz.equals(IntervalFile.class)) continue;
            object = new JButton(fileIcon);
            ((AbstractButton)object).addActionListener(new ActionListener((JTextField)object2){
                final /* synthetic */ JTextField val$textField;
                {
                    this.val$textField = jTextField;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showDialog(JobConfigPanel.this.getParent(), "OK");
                    if (n == 0) {
                        this.val$textField.setText(jFileChooser.getSelectedFile().toString());
                    }
                }
            });
            jPanel.add((Component)object);
        }
        SpringUtilities.makeCompactGrid(this, this.job.numParameters(), 2, 5, 5, 5, 5);
        this.validate();
        this.repaint();
    }
}

