/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Divide
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Divide.class);
    @Parameter(names={"-n", "--numerator"}, description="Dividend / Numerator (file 1)", required=true)
    public WigFile dividendFile;
    @Parameter(names={"-d", "--denominator"}, description="Divisor / Denominator (file 2)", required=true)
    public WigFile divisorFile;

    @Override
    public void setup() {
        this.inputs.add(this.dividendFile);
        this.inputs.add(this.divisorFile);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + string + ":" + n + "-" + n2));
        Iterator iterator = this.dividendFile.query(string, n, n2);
        Iterator iterator2 = this.divisorFile.query(string, n, n2);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n, (int)n2);
        while (iterator2.hasNext()) {
            WigItem wigItem = (WigItem)iterator2.next();
            for (int i = wigItem.getStartBase(); i <= wigItem.getEndBase(); ++i) {
                if (i - n < 0 || i - n >= fArray.length) continue;
                if (wigItem.getWigValue() != 0.0f) {
                    int n3 = i - n;
                    fArray[n3] = fArray[n3] / wigItem.getWigValue();
                    continue;
                }
                fArray[i - n] = Float.NaN;
            }
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new Divide().instanceMain(stringArray);
    }
}

