/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Phasogram
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Phasogram.class);
    @Parameter(names={"-i", "--input"}, description="Input wig file (read counts)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-m", "--max"}, description="Maximum phase shift", required=true)
    public int maxPhase;
    @Parameter(names={"-o", "--output"}, description="Output file (histogram)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        long[] phaseCounts = new long[this.maxPhase + 1];
        for (String chr : this.inputFile.chromosomes()) {
            log.debug((Object)("Processing chromosome " + chr));
            int start = this.inputFile.getChrStart(chr);
            while (start < this.inputFile.getChrStop(chr)) {
                int stop = Math.min(start + 100000 - 1, this.inputFile.getChrStop(chr));
                try {
                    float[] data = WigFile.flattenData((Iterator)this.inputFile.query(chr, start, stop), (int)start, (int)stop);
                    for (int i = 0; i < data.length - this.maxPhase; ++i) {
                        int j = 0;
                        while (j <= this.maxPhase) {
                            int n = j++;
                            phaseCounts[n] = (long)((float)phaseCounts[n] + data[i]);
                        }
                    }
                }
                catch (WigFileException e) {
                    log.fatal((Object)"Error querying data from Wig file!");
                    e.printStackTrace();
                    throw new CommandLineToolException("Error querying data from Wig file!");
                }
                start = stop - this.maxPhase + 1;
            }
        }
        log.debug((Object)"Writing output to disk");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (int i = 0; i < phaseCounts.length; ++i) {
                writer.write(i + "\t" + phaseCounts[i]);
                writer.newLine();
            }
        }
    }

    public static void main(String[] args) {
        new Phasogram().instanceMain(args);
    }
}

