/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Add
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Add.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();

    @Override
    public void setup() {
        if (this.inputFiles.size() < 2) {
            throw new CommandLineToolException("No reason to add < 2 files.");
        }
        log.debug((Object)"Initializing input files");
        for (String inputFile : this.inputFiles) {
            try {
                this.addInputFile(WigFile.autodetect((Path)Paths.get(inputFile, new String[0])));
            }
            catch (WigFileException | IOException e) {
                log.error((Object)("Error initializing input Wig file: " + inputFile));
                e.printStackTrace();
                throw new CommandLineToolException(e.getMessage());
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        log.debug((Object)("Computing sum for chunk " + chr + ":" + start + "-" + stop));
        int length = stop - start + 1;
        float[] sum = new float[length];
        for (WigFile wig : this.inputs) {
            Iterator data = wig.query(chr, start, stop);
            while (data.hasNext()) {
                WigItem item = (WigItem)data.next();
                for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                    if (i - start < 0 || i - start >= sum.length) continue;
                    int n = i - start;
                    sum[n] = sum[n] + item.getWigValue();
                }
            }
        }
        return sum;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Add().instanceMain(args);
    }
}

