/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractIndexScorer;
import java.io.IOException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeightedScorer
extends AbstractIndexScorer {
    private static final Logger LOGGER = Logger.getLogger(AbstractWeightedScorer.class);
    protected Reference2DoubleOpenHashMap<Index> index2Weight = new Reference2DoubleOpenHashMap(1, 0.25f);
    protected double[] currWeight;

    public AbstractWeightedScorer() {
        this.index2Weight.defaultReturnValue(1.0);
    }

    @Override
    public synchronized boolean setWeights(Reference2DoubleMap<Index> index2Weight) {
        this.index2Weight.clear();
        this.index2Weight.defaultReturnValue(0.0);
        double weightSum = 0.0;
        DoubleIterator i = index2Weight.values().iterator();
        while (i.hasNext()) {
            weightSum += i.nextDouble();
        }
        if (weightSum == 0.0) {
            weightSum = 1.0;
        }
        for (Reference2DoubleMap.Entry e : index2Weight.entrySet()) {
            this.index2Weight.put(e.getKey(), e.getDoubleValue() / weightSum);
        }
        this.index2Weight.rehash();
        LOGGER.debug((Object)("New weight map for " + this + ": " + this.index2Weight));
        return true;
    }

    @Override
    public double score() throws IOException {
        double[] weight = this.currWeight;
        Index[] index = this.currIndex;
        double result = 0.0;
        int i = this.n;
        while (i-- != 0) {
            result += weight[i] * this.score(index[i]);
        }
        return result;
    }

    @Override
    public void wrap(DocumentIterator documentIterator) throws IOException {
        super.wrap(documentIterator);
        this.documentIterator = documentIterator;
        this.currWeight = new double[this.n];
        int i = this.n;
        while (i-- != 0) {
            this.currWeight[i] = this.index2Weight.getDouble((Object)this.currIndex[i]);
        }
    }
}

