/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import com.martiansoftware.jsap.JSAPException;
import it.unimi.dsi.mg4j.util.MinimalPerfectHash;
import it.unimi.dsi.mg4j.util.SignedMinimalPerfectHash;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashCodeSignedMinimalPerfectHash
extends SignedMinimalPerfectHash {
    private static final long serialVersionUID = 1L;
    protected int[] signature;

    public HashCodeSignedMinimalPerfectHash(Iterable<? extends CharSequence> terms, int weightLength) {
        super(terms, weightLength);
    }

    public HashCodeSignedMinimalPerfectHash(Iterable<? extends CharSequence> terms) {
        super(terms);
    }

    public HashCodeSignedMinimalPerfectHash(String termFile, String encoding, int weightLength) {
        super(termFile, encoding, weightLength);
    }

    public HashCodeSignedMinimalPerfectHash(String termFile, String encoding) {
        super(termFile, encoding);
    }

    public HashCodeSignedMinimalPerfectHash(String termFile, String encoding, int weightLength, boolean zipped) {
        super(termFile, encoding, weightLength, zipped);
    }

    public HashCodeSignedMinimalPerfectHash(String termFile, String encoding, boolean zipped) {
        super(termFile, encoding, zipped);
    }

    @Override
    public void initSignatures(Iterable<? extends CharSequence> terms) {
        this.signature = new int[this.n];
        int j = 0;
        for (CharSequence charSequence : terms) {
            int l = charSequence.length();
            int h = 0;
            for (int i = 0; i < l; ++i) {
                h = 31 * h + charSequence.charAt(i);
            }
            this.signature[j] = h;
            ++j;
        }
    }

    @Override
    public boolean checkSignature(CharSequence word, int index) {
        if (this.n == 0) {
            return false;
        }
        int l = word.length();
        int h = 0;
        for (int i = 0; i < l; ++i) {
            h = 31 * h + word.charAt(i);
        }
        return this.signature[index] == h;
    }

    @Override
    public boolean checkSignature(byte[] a, int off, int len, int index) {
        if (this.n == 0) {
            return false;
        }
        int h = 0;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + (a[off + i] & 0xFF);
        }
        return this.signature[index] == h;
    }

    public static void main(String[] arg) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        MinimalPerfectHash.main(HashCodeSignedMinimalPerfectHash.class, arg);
    }
}

