/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.mg4j.util.ImmutableExternalTreePrefixDictionary;
import it.unimi.dsi.mg4j.util.ImmutableExternalTriePrefixDictionary;
import it.unimi.dsi.mg4j.util.TernaryIntervalSearchTree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import test.it.unimi.dsi.mg4j.util.TernaryIntervalSearchTreeTest;

public class ImmutableExternalTreePrefixDictionaryTest
extends TestCase {
    public void testLargeSet(int blockSize) throws IOException {
        int j;
        int i;
        List<String> c = Arrays.asList(TernaryIntervalSearchTreeTest.WORDS);
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree(c);
        ImmutableExternalTreePrefixDictionary d = new ImmutableExternalTreePrefixDictionary(c, blockSize);
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTreePrefixDictionaryTest.assertTrue((String)TernaryIntervalSearchTreeTest.WORDS[i], (boolean)d.contains(TernaryIntervalSearchTreeTest.WORDS[i]));
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)TernaryIntervalSearchTreeTest.WORDS[i], (String)((Object)d.get(i)).toString());
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            for (j = 0; j < TernaryIntervalSearchTreeTest.WORDS[i].length(); ++j) {
                String s = TernaryIntervalSearchTreeTest.WORDS[i].substring(0, j + 1);
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s + " ";
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s.substring(0, s.length() - 1) + "~";
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
            }
        }
        ObjectRBTreeSet p = new ObjectRBTreeSet();
        for (int i2 = 0; i2 < TernaryIntervalSearchTreeTest.WORDS.length; ++i2) {
            for (int j2 = 0; j2 < TernaryIntervalSearchTreeTest.WORDS[i2].length(); ++j2) {
                p.add(TernaryIntervalSearchTreeTest.WORDS[i2].substring(0, j2 + 1));
            }
        }
        d = new ImmutableExternalTreePrefixDictionary((Iterable<? extends CharSequence>)p, blockSize);
        t = new TernaryIntervalSearchTree((Collection<? extends CharSequence>)p);
        j = 0;
        for (String s : p) {
            ImmutableExternalTreePrefixDictionaryTest.assertTrue((String)s, (boolean)d.contains(s));
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (String)((Object)d.get(j++)).toString());
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
            s = s + " ";
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
            s = s.substring(0, s.length() - 1) + "~";
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
        }
        ObjectIterator<CharSequence> k = d.iterator();
        Iterator i3 = p.iterator();
        while (i3.hasNext()) {
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((boolean)i3.hasNext(), (boolean)k.hasNext());
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)((String)i3.next()).toString(), (String)((Object)((CharSequence)k.next())).toString());
        }
    }

    public void testLargeSet1() throws IOException {
        this.testLargeSet(1);
    }

    public void testLargeSet2() throws IOException {
        this.testLargeSet(2);
    }

    public void testLargeSet4() throws IOException {
        this.testLargeSet(4);
    }

    public void testLargeSet8() throws IOException {
        this.testLargeSet(8);
    }

    public void testLargeSet16() throws IOException {
        this.testLargeSet(16);
    }

    public void testLargeSet32() throws IOException {
        this.testLargeSet(32);
    }

    public void testLargeSet64() throws IOException {
        this.testLargeSet(64);
    }

    public void testLargeSet128() throws IOException {
        this.testLargeSet(128);
    }

    public void testLargeSet256() throws IOException {
        this.testLargeSet(256);
    }

    public void testLargeSet1024() throws IOException {
        this.testLargeSet(1024);
    }

    public void testLargeSet16384() throws IOException {
        this.testLargeSet(16384);
    }

    public void testAgainstTrie(int blockSize) throws IOException {
        int j;
        int i;
        List<String> c = Arrays.asList(TernaryIntervalSearchTreeTest.WORDS);
        ImmutableExternalTriePrefixDictionary t = new ImmutableExternalTriePrefixDictionary(c, blockSize);
        ImmutableExternalTreePrefixDictionary d = new ImmutableExternalTreePrefixDictionary(c, blockSize);
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTreePrefixDictionaryTest.assertTrue((String)TernaryIntervalSearchTreeTest.WORDS[i], (boolean)d.contains(TernaryIntervalSearchTreeTest.WORDS[i]));
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)TernaryIntervalSearchTreeTest.WORDS[i], (String)((Object)d.get(i)).toString());
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            for (j = 0; j < TernaryIntervalSearchTreeTest.WORDS[i].length(); ++j) {
                String s = TernaryIntervalSearchTreeTest.WORDS[i].substring(0, j + 1);
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s + " ";
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s.substring(0, s.length() - 1) + "~";
                ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
            }
        }
        ObjectRBTreeSet p = new ObjectRBTreeSet();
        for (int i2 = 0; i2 < TernaryIntervalSearchTreeTest.WORDS.length; ++i2) {
            for (int j2 = 0; j2 < TernaryIntervalSearchTreeTest.WORDS[i2].length(); ++j2) {
                p.add(TernaryIntervalSearchTreeTest.WORDS[i2].substring(0, j2 + 1));
            }
        }
        d = new ImmutableExternalTreePrefixDictionary((Iterable<? extends CharSequence>)p, blockSize);
        t = new ImmutableExternalTriePrefixDictionary((Iterable<? extends CharSequence>)p);
        j = 0;
        for (String s : p) {
            ImmutableExternalTreePrefixDictionaryTest.assertTrue((String)s, (boolean)d.contains(s));
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (String)((Object)d.get(j++)).toString());
            ImmutableExternalTreePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
        }
    }

    public void testAgainstTrie1() throws IOException {
        this.testAgainstTrie(1);
    }

    public void testAgainstTrie2() throws IOException {
        this.testAgainstTrie(2);
    }

    public void testAgainstTrie4() throws IOException {
        this.testAgainstTrie(4);
    }

    public void testAgainstTrie8() throws IOException {
        this.testAgainstTrie(8);
    }

    public void testAgainstTrie16() throws IOException {
        this.testAgainstTrie(16);
    }

    public void testAgainstTrie32() throws IOException {
        this.testAgainstTrie(32);
    }

    public void testAgainstTrie64() throws IOException {
        this.testAgainstTrie(64);
    }

    public void testAgainstTrie128() throws IOException {
        this.testAgainstTrie(128);
    }

    public void testAgainstTrie256() throws IOException {
        this.testAgainstTrie(256);
    }

    public void testAgainstTrie1024() throws IOException {
        this.testAgainstTrie(1024);
    }

    public void testAgainstTrie16384() throws IOException {
        this.testAgainstTrie(16384);
    }

    public void testOverflow() throws IOException {
        List<String> c = Arrays.asList("b", "mamma", "tre");
        ImmutableExternalTriePrefixDictionary t = new ImmutableExternalTriePrefixDictionary(c, 1);
        ImmutableExternalTreePrefixDictionaryTest.assertTrue((boolean)t.contains("b"));
        ImmutableExternalTreePrefixDictionaryTest.assertTrue((boolean)t.contains("mamma"));
        ImmutableExternalTreePrefixDictionaryTest.assertTrue((boolean)t.contains("tre"));
    }
}

