/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BPTreeHeader {
    private static Logger log = Logger.getLogger(BPTreeHeader.class);
    public static final int BPTREE_HEADER_SIZE = 32;
    public static final int BPTREE_MAGIC_LTH = 2026540177;
    public static final int BPTREE_MAGIC_HTL = -1853044104;
    private long headerOffset;
    private boolean headerOK;
    private int magic;
    private int blockSize;
    private int keySize;
    private int valSize;
    private long itemCount;
    private long reserved;

    public BPTreeHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        this.headerOffset = fileOffset;
        this.headerOK = this.readHeader(fis, this.headerOffset, isLowToHigh);
    }

    public static int getHeaderSize() {
        return 32;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public boolean isHeaderOK() {
        return this.headerOK;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValSize() {
        return this.valSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void print() {
        if (this.headerOK) {
            log.debug((Object)("B+ Tree Header was read from file location " + this.headerOffset));
        }
        log.debug((Object)(" Magic ID =" + this.magic));
        log.debug((Object)(" Block size = " + this.blockSize));
        log.debug((Object)(" Key size = " + this.keySize));
        log.debug((Object)(" Indexed value size = " + this.valSize));
        log.debug((Object)(" Item Count = " + this.itemCount));
        log.debug((Object)(" Reserved = " + this.reserved));
    }

    private boolean readHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        byte[] buffer = new byte[32];
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                LittleEndianInputStream lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
                this.magic = lbdis.readInt();
                if (this.magic != 2026540177) {
                    return false;
                }
                this.blockSize = lbdis.readInt();
                this.keySize = lbdis.readInt();
                this.valSize = lbdis.readInt();
                this.itemCount = lbdis.readLong();
                this.reserved = lbdis.readLong();
            } else {
                DataInputStream bdis = new DataInputStream(new ByteArrayInputStream(buffer));
                this.magic = bdis.readInt();
                if (this.magic != -1853044104) {
                    return false;
                }
                this.blockSize = bdis.readInt();
                this.keySize = bdis.readInt();
                this.valSize = bdis.readInt();
                this.itemCount = bdis.readLong();
                this.reserved = bdis.readLong();
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error reading B+ tree header " + ex));
            throw new RuntimeException("Error reading B+ tree header \n", ex);
        }
        return true;
    }
}

