/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;
import org.broad.igv.bbfile.RPTreeNodeProxy;

public class RPTreeChildNodeItem
implements RPTreeNodeItem {
    private static Logger log = Logger.getLogger(RPTreeChildNodeItem.class);
    private RPChromosomeRegion chromosomeBounds;
    private RPTreeNode childNode;

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, RPTreeNode childNode) {
        this.chromosomeBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        this.childNode = childNode;
    }

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, long childDataOffset) {
        this.chromosomeBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public RPTreeNode getChildNode() {
        if (this.childNode instanceof RPTreeNodeProxy) {
            RPTreeNodeProxy proxy = (RPTreeNodeProxy)this.childNode;
            this.childNode = RPTree.readRPTreeNode(proxy.fis, proxy.fileOffset, proxy.isLowToHigh, true);
        }
        return this.childNode;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public void print() {
        log.debug((Object)"Child node item :\n");
        log.debug((Object)(" StartChromID = " + this.chromosomeBounds.getStartChromID() + "\n"));
        log.debug((Object)(" StartBase = " + this.chromosomeBounds.getStartBase() + "\n"));
        log.debug((Object)(" EndChromID = " + this.chromosomeBounds.getEndChromID() + "\n"));
        log.debug((Object)(" EndBase = " + this.chromosomeBounds.getEndBase() + "\n"));
        this.childNode.printItems();
    }
}

